/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlTransformRouteTest
extends ContextTestSupport {
    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml, null);
        NodeList nodes = doc.getElementsByTagName("simple");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <simple> expected to be instanceof Element");
        Assertions.assertEquals((Object)"Hello ${body}", (Object)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <to> expected to be instanceof Element");
        Assertions.assertEquals((Object)"mock:result", (Object)node.getAttribute("uri"));
        Assertions.assertEquals((Object)"myMock", (Object)node.getAttribute("id"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start").routeId("myRoute").transform().simple("Hello ${body}")).to("mock:result")).id("myMock");
            }
        };
    }
}

