/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlRouteTemplateTest
extends ContextTestSupport {
    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteTemplateDefinition("myTemplate"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml, null);
        NodeList nodes = doc.getElementsByTagName("simple");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <simple> expected to be instanceof Element");
        Assertions.assertEquals((Object)"{{greeting}}", (Object)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <to> expected to be instanceof Element");
        Assertions.assertEquals((Object)"mock:{{whereto}}", (Object)node.getAttribute("uri"));
        nodes = doc.getElementsByTagName("routeTemplate");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertEquals((Object)"myTemplate", (Object)node.getAttribute("id"));
        nodes = doc.getElementsByTagName("templateParameter");
        Assertions.assertEquals((int)2, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertEquals((Object)"greeting", (Object)node.getAttribute("name"));
        node = (Element)nodes.item(1);
        Assertions.assertEquals((Object)"whereto", (Object)node.getAttribute("name"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.routeTemplate("myTemplate").templateParameter("greeting").templateParameter("whereto").from("direct:start").transform((Expression)this.simple("{{greeting}}"))).to("mock:{{whereto}}");
            }
        };
    }
}

