/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.MyBarSingleton;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpModelAsXmlRouteExpressionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myCoolBean", (Object)new MyBarSingleton());
        return jndi;
    }

    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xml.contains("<simple>Hello ${body}</simple>"));
    }

    @Test
    public void testDumpModelAsXmlXPath() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myOtherRoute"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xml.contains("<xpath>/foo</xpath>"));
    }

    @Test
    public void testDumpModelAsXmlHeader() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myFooRoute"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    @Test
    public void testDumpModelAsXmlBean() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myBeanRoute"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertThat((String)xml).containsPattern((CharSequence)"<setHeader id=\"setHeader[0-9]+\" name=\"foo\">");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xml.contains("<method ref=\"myCoolBean\"/>"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").setBody((Expression)this.simple("Hello ${body}"))).to("mock:result");
                ((RouteDefinition)this.from("direct:other").routeId("myOtherRoute").setBody((Expression)this.xpath("/foo"))).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").routeId("myFooRoute").setBody((Expression)this.header("bar"))).to("mock:result");
                ((RouteDefinition)this.from("direct:bean").routeId("myBeanRoute").setHeader("foo", (Expression)this.method("myCoolBean"))).to("mock:result");
            }
        };
    }
}

