/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.builder.Namespaces;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlNamespaceTest
extends ContextTestSupport {
    private static final String URL_FOO = "http://foo.com";
    private static final String URL_BAR = "http://bar.com";

    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        Document dom = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        NodeList nl = dom.getElementsByTagName("xpath");
        Assertions.assertEquals((int)2, (int)nl.getLength());
        String attributeFoo = dom.getDocumentElement().getAttribute("xmlns:foo");
        if (attributeFoo.isEmpty()) {
            Element n1 = (Element)nl.item(0);
            attributeFoo = n1.getAttribute("xmlns:foo");
        }
        Assertions.assertNotNull((Object)attributeFoo);
        Assertions.assertEquals((Object)URL_FOO, (Object)attributeFoo);
        String attributeBar = dom.getDocumentElement().getAttribute("xmlns:bar");
        if (attributeBar.isEmpty()) {
            Element n1 = (Element)nl.item(0);
            attributeBar = n1.getAttribute("xmlns:bar");
        }
        Assertions.assertNotNull((Object)attributeBar);
        Assertions.assertEquals((Object)URL_BAR, (Object)attributeBar);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces foo = new Namespaces("foo", DumpModelAsXmlNamespaceTest.URL_FOO);
                Namespaces bar = new Namespaces("bar", DumpModelAsXmlNamespaceTest.URL_BAR);
                ((ChoiceDefinition)this.from("direct:start").routeId("myRoute").choice().when((Predicate)this.xpath("/foo:customer", foo)).to("mock:foo")).when((Predicate)this.xpath("/bar:customer", bar)).to("mock:bar");
            }
        };
    }
}

