/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlFromRouteTemplateTest
extends ContextTestSupport {
    @Test
    public void testDumpModelAsXml() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar", "start");
        map.put("greeting", "Hello");
        map.put("whereto", "Moes");
        this.context.addRouteFromTemplate("foo", "myTemplate", map);
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("foo"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml, null);
        NodeList nodes = doc.getElementsByTagName("simple");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <simple> expected to be instanceof Element");
        Assertions.assertEquals((Object)"{{greeting}}", (Object)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <to> expected to be instanceof Element");
        Assertions.assertEquals((Object)"mock:{{whereto}}", (Object)node.getAttribute("uri"));
        nodes = doc.getElementsByTagName("route");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertEquals((Object)"foo", (Object)node.getAttribute("id"));
    }

    @Test
    public void testDumpModelAsXmlResolvePlaceholder() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar", "start");
        map.put("greeting", "Hello");
        map.put("whereto", "Moes");
        this.context.addRouteFromTemplate("bar", "myTemplate", map);
        map.clear();
        map.put("bar", "start2");
        map.put("greeting", "Bye");
        map.put("whereto", "Jacks");
        this.context.addRouteFromTemplate("bar2", "myTemplate", map);
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("bar"), true, true);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml, null);
        NodeList nodes = doc.getElementsByTagName("simple");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <simple> expected to be instanceof Element");
        Assertions.assertEquals((Object)"Hello", (Object)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <to> expected to be instanceof Element");
        Assertions.assertEquals((Object)"mock:Moes", (Object)node.getAttribute("uri"));
        nodes = doc.getElementsByTagName("route");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertEquals((Object)"bar", (Object)node.getAttribute("id"));
        xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("bar2"), true, true);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        doc = new XmlConverter().toDOMDocument(xml, null);
        nodes = doc.getElementsByTagName("simple");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <simple> expected to be instanceof Element");
        Assertions.assertEquals((Object)"Bye", (Object)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertNotNull((Object)node, (String)"Node <to> expected to be instanceof Element");
        Assertions.assertEquals((Object)"mock:Jacks", (Object)node.getAttribute("uri"));
        nodes = doc.getElementsByTagName("route");
        Assertions.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        Assertions.assertEquals((Object)"bar2", (Object)node.getAttribute("id"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.routeTemplate("myTemplate").templateParameter("bar").templateParameter("greeting").templateParameter("whereto").from("direct:{{bar}}").transform((Expression)this.simple("{{greeting}}"))).to("mock:{{whereto}}");
            }
        };
    }
}

