/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpModelAsXmlChoiceFilterRouteTest
extends ContextTestSupport {
    @Test
    public void testDumpModelAsXmlNoEmptyLines() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        for (String line : xml.split("\n")) {
            line = line.trim();
            Assertions.assertFalse((boolean)line.isEmpty(), (String)"Should not contain empty lines");
        }
    }

    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<header>dude</header>"));
        Assertions.assertTrue((boolean)xml.contains("<header>gold</header>"));
        Assertions.assertTrue((boolean)xml.contains("<header>extra-gold</header>"));
        Assertions.assertTrue((boolean)xml.contains("<simple>${body} contains 'Camel'</simple>"));
    }

    @Test
    public void testDumpModelAsXmAl() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("a"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<constant>bar</constant>"));
        Assertions.assertTrue((boolean)xml.contains("<expressionDefinition>header{test} is not null</expressionDefinition>"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((FilterDefinition)((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("log:input")).transform().header("dude")).choice().when().header("gold")).to("mock:gold")).filter().header("extra-gold")).to("mock:extra-gold")).endChoice().when().simple("${body} contains 'Camel'")).to("mock:camel")).otherwise().to("mock:other")).end().to("mock:result");
                ((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)this.from("seda:a").routeId("a").setProperty("foo").constant((Object)"bar")).choice().when(this.header("test").isNotNull()).log("not null")).when((Predicate)this.xpath("/foo/bar")).log("xpath")).end().to("mock:a");
            }
        };
    }
}

