/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.CaseInsensitiveMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CaseInsensitiveMapTest {
    @Test
    public void testLookupCaseAgnostic() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeader() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        Assertions.assertEquals((Object)"beer", map.get("bar"));
        Assertions.assertEquals((Object)"beer", map.get("Bar"));
        Assertions.assertEquals((Object)"beer", map.get("BAR"));
        Assertions.assertNull(map.get("unknown"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeader2() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        Assertions.assertEquals((Object)"beer", map.get("BAR"));
        Assertions.assertEquals((Object)"beer", map.get("bar"));
        Assertions.assertEquals((Object)"beer", map.get("Bar"));
        Assertions.assertNull(map.get("unknown"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeaderRemoveHeader() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertNull(map.get("unknown"));
        map.put("bar", "beer");
        Assertions.assertEquals((Object)"beer", map.get("bar"));
        Assertions.assertEquals((Object)"beer", map.get("Bar"));
        Assertions.assertEquals((Object)"beer", map.get("BAR"));
        Assertions.assertNull(map.get("unknown"));
        map.remove("bar");
        Assertions.assertNull(map.get("bar"));
        Assertions.assertNull(map.get("unknown"));
    }

    @Test
    public void testSetWithDifferentCase() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        map.put("Foo", "bar");
        Assertions.assertEquals((Object)"bar", map.get("FOO"));
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"bar", map.get("Foo"));
    }

    @Test
    public void testRemoveWithDifferentCase() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        map.put("Foo", "bar");
        Assertions.assertEquals((Object)"bar", map.get("FOO"));
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"bar", map.get("Foo"));
        map.remove("FOO");
        Assertions.assertNull(map.get("foo"));
        Assertions.assertNull(map.get("Foo"));
        Assertions.assertNull(map.get("FOO"));
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutAll() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        map.putAll(other);
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)123, map.get("BAR"));
        Assertions.assertEquals((Object)123, map.get("bar"));
        Assertions.assertEquals((Object)123, map.get("BaR"));
        HashMap keys = new HashMap(map);
        Assertions.assertEquals((Object)"cheese", keys.get("Foo"));
        Assertions.assertNull(keys.get("foo"));
        Assertions.assertNull(keys.get("FOO"));
        Assertions.assertEquals((Object)123, keys.get("bar"));
        Assertions.assertNull(keys.get("Bar"));
        Assertions.assertNull(keys.get("BAR"));
    }

    @Test
    public void testPutAllOther() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        Assertions.assertNull(map.get("foo"));
        HashMap<String, Object> other = new HashMap<String, Object>();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        map.putAll(other);
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)123, map.get("BAR"));
        Assertions.assertEquals((Object)123, map.get("bar"));
        Assertions.assertEquals((Object)123, map.get("BaR"));
    }

    @Test
    public void testPutAllEmpty() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "cheese");
        map.putAll(new HashMap());
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void testConstructFromOther() {
        HashMap<String, Object> other = new HashMap<String, Object>();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        CaseInsensitiveMap map = new CaseInsensitiveMap(other);
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)123, map.get("BAR"));
        Assertions.assertEquals((Object)123, map.get("bar"));
        Assertions.assertEquals((Object)123, map.get("BaR"));
    }

    @Test
    public void testKeySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", 123);
        map.put("baZ", "beer");
        Set keys = map.keySet();
        Assertions.assertTrue((boolean)keys.contains("Foo"));
        Assertions.assertTrue((boolean)keys.contains("foo"));
        Assertions.assertTrue((boolean)keys.contains("FOO"));
        Assertions.assertTrue((boolean)keys.contains("BAR"));
        Assertions.assertTrue((boolean)keys.contains("bar"));
        Assertions.assertTrue((boolean)keys.contains("Bar"));
        Assertions.assertTrue((boolean)keys.contains("baZ"));
        Assertions.assertTrue((boolean)keys.contains("baz"));
        Assertions.assertTrue((boolean)keys.contains("Baz"));
        Assertions.assertTrue((boolean)keys.contains("BAZ"));
    }

    @Test
    public void testRetainKeysCopyToAnotherMap() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", 123);
        map.put("baZ", "beer");
        HashMap other = new HashMap(map);
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertFalse((boolean)other.containsKey("FOO"));
        Assertions.assertTrue((boolean)other.containsKey("BAR"));
        Assertions.assertFalse((boolean)other.containsKey("bar"));
        Assertions.assertFalse((boolean)other.containsKey("Bar"));
        Assertions.assertTrue((boolean)other.containsKey("baZ"));
        Assertions.assertFalse((boolean)other.containsKey("baz"));
        Assertions.assertFalse((boolean)other.containsKey("Baz"));
        Assertions.assertFalse((boolean)other.containsKey("BAZ"));
    }

    @Test
    public void testValues() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "123");
        map.put("baZ", "Beer");
        Iterator it = map.values().iterator();
        Assertions.assertEquals((Object)"String", (Object)it.next().getClass().getSimpleName());
        Assertions.assertEquals((Object)"String", (Object)it.next().getClass().getSimpleName());
        Assertions.assertEquals((Object)"String", (Object)it.next().getClass().getSimpleName());
        Collection values = map.values();
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertTrue((boolean)values.contains("cheese"));
        Assertions.assertTrue((boolean)values.contains("123"));
        Assertions.assertTrue((boolean)values.contains("Beer"));
    }

    @Test
    public void testRomeks() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "cheese");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"cheese", map.get("fOo"));
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("FOO"));
        Assertions.assertTrue((boolean)map.containsKey("FOO"));
        Assertions.assertTrue((boolean)map.containsKey("FoO"));
        Assertions.assertTrue((boolean)map.containsKey("Foo"));
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("fOO"));
        map.put("FOO", "cake");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("FOO"));
        Assertions.assertEquals((Object)"cake", map.get("fOo"));
    }

    @Test
    public void testRomeksUsingRegularHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "cheese");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertNull(map.get("fOo"));
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertFalse((boolean)map.containsKey("FOO"));
        Assertions.assertFalse((boolean)map.containsKey("FOO"));
        map.put("FOO", "cake");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("FOO"));
        Assertions.assertNull(map.get("fOo"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cake", map.get("FOO"));
    }

    @Test
    public void testRomeksTransferredToHashMapAfterwards() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("FOO", "cake");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("FOO"));
        HashMap other = new HashMap(map);
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertFalse((boolean)other.containsKey("FOO"));
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertEquals((int)1, (int)other.size());
    }

    @Test
    public void testSerialization() throws Exception {
        CaseInsensitiveMap testMap = new CaseInsensitiveMap();
        testMap.put((Object)"key", (Object)"value");
        testMap.entrySet();
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(bStream);
        objStream.writeObject(testMap);
        ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(bStream.toByteArray()));
        CaseInsensitiveMap testMapCopy = (CaseInsensitiveMap)inStream.readObject();
        Assertions.assertTrue((boolean)testMapCopy.containsKey((Object)"key"));
    }

    @Test
    public void testCopyToAnotherMapPreserveKeyCaseEntrySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        HashMap other = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            other.put(key, value);
        }
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertFalse((boolean)other.containsKey("bar"));
        Assertions.assertTrue((boolean)other.containsKey("BAR"));
        Assertions.assertEquals((int)2, (int)other.size());
    }

    @Test
    public void testCopyToAnotherMapPreserveKeyCasePutAll() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        HashMap other = new HashMap(map);
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertFalse((boolean)other.containsKey("bar"));
        Assertions.assertTrue((boolean)other.containsKey("BAR"));
        Assertions.assertEquals((int)2, (int)other.size());
    }

    @Test
    public void testCopyToAnotherMapPreserveKeyCaseCtr() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        HashMap other = new HashMap(map);
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertFalse((boolean)other.containsKey("bar"));
        Assertions.assertTrue((boolean)other.containsKey("BAR"));
        Assertions.assertEquals((int)2, (int)other.size());
    }

    @Test
    public void testCopyToAnotherMapPreserveKeyKeySet() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Foo", "cheese");
        map.put("BAR", "cake");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        HashMap other = new HashMap(map);
        Assertions.assertFalse((boolean)other.containsKey("foo"));
        Assertions.assertTrue((boolean)other.containsKey("Foo"));
        Assertions.assertFalse((boolean)other.containsKey("bar"));
        Assertions.assertTrue((boolean)other.containsKey("BAR"));
        Assertions.assertEquals((int)2, (int)other.size());
    }

    @Test
    public void testConcurrent() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(5);
        CountDownLatch latch = new CountDownLatch(1000);
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        int i = 0;
        while (i < 1000) {
            final int count = i++;
            service.submit(new Runnable(){
                final /* synthetic */ Map val$map;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$map = map;
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CaseInsensitiveMap foo = new CaseInsensitiveMap();
                    foo.put("counter" + count, count);
                    foo.put("foo", 123);
                    foo.put("bar", 456);
                    foo.put("cake", "cheese");
                    Map map = this.val$map;
                    synchronized (map) {
                        this.val$map.putAll(foo);
                    }
                    this.val$latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1003, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey("counter0"));
        Assertions.assertTrue((boolean)map.containsKey("counter500"));
        Assertions.assertTrue((boolean)map.containsKey("counter999"));
        Assertions.assertEquals((Object)123, map.get("FOO"));
        Assertions.assertEquals((Object)456, map.get("Bar"));
        Assertions.assertEquals((Object)"cheese", map.get("cAKe"));
        service.shutdownNow();
    }

    @Disabled(value="Manual test")
    @Test
    public void testCopyMapWithCamelHeadersTest() throws Exception {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("CamelA", "A");
        map.put("CamelB", "B");
        map.put("CamelC", "C");
        ArrayList<CaseInsensitiveMap> maps = new ArrayList<CaseInsensitiveMap>();
        for (int i = 0; i < 10000; ++i) {
            CaseInsensitiveMap copy = new CaseInsensitiveMap((Map)map);
            Assertions.assertEquals((int)3, (int)copy.size());
            Assertions.assertEquals((Object)"A", copy.get("CamelA"));
            Assertions.assertEquals((Object)"B", copy.get("CamelB"));
            Assertions.assertEquals((Object)"C", copy.get("CamelC"));
            maps.add(copy);
        }
        Assertions.assertEquals((int)10000, (int)maps.size());
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"A", map.get("CamelA"));
        Assertions.assertEquals((Object)"B", map.get("CamelB"));
        Assertions.assertEquals((Object)"C", map.get("CamelC"));
        Thread.sleep(9999999L);
    }
}

