/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.Callable;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.CamelContextHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelContextHelperTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Test
    public void testParsing() {
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"TRUE"), true);
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"true"), true);
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"FALSE"), false);
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"false"), false);
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"TrUe"), true);
        this.eq(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"FaLsE"), false);
        this.fl(() -> CamelContextHelper.parseBoolean((CamelContext)this.context, (String)"5"), IllegalArgumentException.class);
        this.eq(() -> CamelContextHelper.parseInteger((CamelContext)this.context, (String)"5"), 5);
        this.eq(() -> CamelContextHelper.parseInteger((CamelContext)this.context, (String)"-5"), -5);
        this.fl(() -> CamelContextHelper.parseInteger((CamelContext)this.context, (String)"5.0"), IllegalArgumentException.class);
    }

    private <T> void eq(Callable<T> r, T value) {
        try {
            T t = r.call();
            Assertions.assertEquals(value, t);
        }
        catch (Throwable t) {
            Assertions.fail((String)("Exception thrown: " + String.valueOf(t)));
        }
    }

    private <T> void fl(Callable<T> r, Class<? extends Exception> exceptionClass) {
        try {
            r.call();
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Throwable t) {
            Assertions.assertTrue((boolean)exceptionClass.isInstance(t), (String)("Expected a " + String.valueOf(exceptionClass) + " exception"));
        }
    }

    @Test
    public void testGetMandatoryEndpoint() {
        MockEndpoint mock = (MockEndpoint)CamelContextHelper.getMandatoryEndpoint((CamelContext)this.context, (String)"mock:foo", MockEndpoint.class);
        Assertions.assertNotNull((Object)mock);
    }

    @Test
    public void testMandatoryConvertTo() {
        Integer num = (Integer)CamelContextHelper.mandatoryConvertTo((CamelContext)this.context, Integer.class, (Object)"5");
        Assertions.assertEquals((int)5, (int)num);
    }

    @Test
    public void testMandatoryConvertToNotPossible() {
        try {
            CamelContextHelper.mandatoryConvertTo((CamelContext)this.context, CamelContext.class, (Object)"5");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLookupBean() {
        Object foo = CamelContextHelper.lookup((CamelContext)this.context, (String)"foo");
        Assertions.assertNotNull((Object)foo);
        CamelContextHelperTest.assertIsInstanceOf(MyFooBean.class, foo);
    }

    @Test
    public void testLookupBeanAndType() {
        MyFooBean foo = (MyFooBean)CamelContextHelper.lookup((CamelContext)this.context, (String)"foo", MyFooBean.class);
        Assertions.assertNotNull((Object)foo);
    }

    @Test
    public void testRouteStartupOrder() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").startupOrder(222).to("mock:foo");
                this.from("direct:bar").routeId("bar").startupOrder(111).to("mock:bar");
            }
        });
        Assertions.assertEquals((int)111, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"bar"));
        Assertions.assertEquals((int)222, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"foo"));
        Assertions.assertEquals((int)0, (int)CamelContextHelper.getRouteStartupOrder((CamelContext)this.context, (String)"zzz"));
    }

    public static class MyFooBean {
    }
}

