/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.urlhandler.pd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceResolverSupport;
import org.apache.camel.support.ResourceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends ResourceResolverSupport {
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    private static final String XSD_TEMPLATE_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema targetNamespace=\"http://apache.camel.org/test\"             xmlns=\"http://apache.camel.org/test\"             xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <xsd:complexType name=\"TestMessage\">        <xsd:sequence>            <xsd:element name=\"Content\" type=\"xsd:string\" />        </xsd:sequence>        <xsd:attribute name=\"attr\" type=\"xsd:string\" default=\"xsd1\"/>    </xsd:complexType>    <xsd:element name=\"TestMessage\" type=\"TestMessage\" /></xsd:schema>";
    private static final String XSD_TEMPLATE_2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema targetNamespace=\"http://apache.camel.org/test\"             xmlns=\"http://apache.camel.org/test\"             xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <xsd:complexType name=\"TestMessage\">        <xsd:sequence>            <xsd:element name=\"Content\" type=\"xsd:string\" />        </xsd:sequence>        <xsd:attribute name=\"attr\" type=\"xsd:string\" default=\"xsd1\"/>    </xsd:complexType>    <xsd:element name=\"TestMessage\" type=\"TestMessage\" /></xsd:schema>".replace("\"Content\"", "\"MessageContent\"");
    private final AtomicInteger counter = new AtomicInteger();

    public Handler() {
        super("pd");
    }

    protected Resource createResource(String location, String remaining) {
        return new ResourceSupport("mem", location){

            public boolean exists() {
                return true;
            }

            public InputStream getInputStream() {
                if (Handler.this.counter.getAndIncrement() == 0) {
                    LOG.info("resolved XSD1");
                    return new ByteArrayInputStream(Handler.XSD_TEMPLATE_1.getBytes(StandardCharsets.UTF_8));
                }
                LOG.info("resolved XSD2");
                return new ByteArrayInputStream(XSD_TEMPLATE_2.getBytes(StandardCharsets.UTF_8));
            }
        };
    }
}

