/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.state;

import java.io.File;
import org.apache.camel.TestSupport;
import org.apache.camel.support.processor.state.FileStateRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileStateRepositoryTest
extends TestSupport {
    private File repositoryStore;

    @BeforeEach
    public void setUpTemporaryFile() {
        this.repositoryStore = this.testFile("file-state-repository.dat").toFile();
    }

    @Test
    public void shouldPreventUsingDelimiterInKey() {
        FileStateRepository repository = FileStateRepository.fileStateRepository((File)this.repositoryStore);
        Assertions.assertThrows(IllegalArgumentException.class, () -> repository.setState("=", "value"));
    }

    @Test
    public void shouldPreventUsingNewLineInKey() throws Exception {
        FileStateRepository repository = this.createRepository();
        Assertions.assertThrows(IllegalArgumentException.class, () -> repository.setState("=", "value"));
    }

    @Test
    public void shouldPreventUsingNewLineInValue() throws Exception {
        FileStateRepository repository = this.createRepository();
        Assertions.assertThrows(IllegalArgumentException.class, () -> repository.setState("key", "\n"));
    }

    @Test
    public void shouldSaveState() throws Exception {
        FileStateRepository repository = this.createRepository();
        repository.setState("key", "value");
        Assertions.assertEquals((Object)"value", (Object)repository.getState("key"));
    }

    @Test
    public void shouldUpdateState() throws Exception {
        FileStateRepository repository = this.createRepository();
        repository.setState("key", "value");
        repository.setState("key", "value2");
        Assertions.assertEquals((Object)"value2", (Object)repository.getState("key"));
    }

    @Test
    public void shouldSynchronizeInFile() throws Exception {
        FileStateRepository repository = this.createRepository();
        repository.setState("key1", "value1");
        repository.setState("key2", "value2");
        repository.setState("key3", "value3");
        FileStateRepository newRepository = this.createRepository();
        Assertions.assertEquals((Object)"value1", (Object)newRepository.getState("key1"));
        Assertions.assertEquals((Object)"value2", (Object)newRepository.getState("key2"));
        Assertions.assertEquals((Object)"value3", (Object)newRepository.getState("key3"));
    }

    @Test
    public void shouldPreventRepositoryFileFromGrowingInfinitely() throws Exception {
        FileStateRepository repository = this.createRepository();
        repository.setMaxFileStoreSize(100L);
        for (int i = 0; i < 10; ++i) {
            repository.setState("key", "xxxxx".replace('x', (char)(48 + i)));
        }
        long previousSize = this.repositoryStore.length();
        repository.setState("key", "value");
        Assertions.assertTrue((this.repositoryStore.length() < previousSize ? 1 : 0) != 0);
    }

    private FileStateRepository createRepository() {
        FileStateRepository repository = FileStateRepository.fileStateRepository((File)this.repositoryStore);
        repository.start();
        return repository;
    }
}

