/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.idempotent;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.camel.TestSupport;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileIdempotentStoreOrderingTest
extends TestSupport {
    private FileIdempotentRepository fileIdempotentRepository;
    private List<String> files;

    @BeforeEach
    public void setup() {
        this.files = Arrays.asList("file1.txt.20171123", "file2.txt.20171123", "file1.txt.20171124", "file3.txt.20171125", "file2.txt.20171126", "fixed.income.lamr.out.20171126", "pricing.px.20171126", "test.out.20171126", "processing.source.lamr.out.20171126");
        this.fileIdempotentRepository = new FileIdempotentRepository();
    }

    @Test
    public void testTrunkStoreNotMaxHit() throws Exception {
        File fileStore = this.testDirectory().resolve("data.dat").toFile();
        this.fileIdempotentRepository.setFileStore(fileStore);
        this.fileIdempotentRepository.setCacheSize(10);
        this.fileIdempotentRepository.start();
        this.files.forEach(e -> this.fileIdempotentRepository.add(e));
        this.fileIdempotentRepository.stop();
        try (Stream<String> fileContent = Files.lines(fileStore.toPath());){
            List<String> fileEntries = fileContent.toList();
            MatcherAssert.assertThat(fileEntries, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"file1.txt.20171123", "file2.txt.20171123", "file1.txt.20171124", "file3.txt.20171125", "file2.txt.20171126", "fixed.income.lamr.out.20171126", "pricing.px.20171126", "test.out.20171126", "processing.source.lamr.out.20171126"}));
        }
    }

    @Test
    public void testTrunkStoreFirstLevelMaxHit() throws Exception {
        File fileStore = this.testDirectory().resolve("data.dat").toFile();
        this.fileIdempotentRepository.setFileStore(fileStore);
        this.fileIdempotentRepository.setCacheSize(5);
        this.fileIdempotentRepository.start();
        this.files.forEach(e -> this.fileIdempotentRepository.add(e));
        this.fileIdempotentRepository.stop();
        try (Stream<String> fileContent = Files.lines(fileStore.toPath());){
            List<String> fileEntries = fileContent.toList();
            MatcherAssert.assertThat(fileEntries, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"file1.txt.20171123", "file2.txt.20171123", "file1.txt.20171124", "file3.txt.20171125", "file2.txt.20171126", "fixed.income.lamr.out.20171126", "pricing.px.20171126", "test.out.20171126", "processing.source.lamr.out.20171126"}));
        }
    }

    @Test
    public void testTrunkStoreFileMaxHit() throws Exception {
        File fileStore = this.testDirectory().resolve("data.dat").toFile();
        this.fileIdempotentRepository.setFileStore(fileStore);
        this.fileIdempotentRepository.setCacheSize(5);
        this.fileIdempotentRepository.setMaxFileStoreSize(128L);
        this.fileIdempotentRepository.setDropOldestFileStore(1000L);
        this.fileIdempotentRepository.start();
        this.files.forEach(e -> this.fileIdempotentRepository.add(e));
        this.fileIdempotentRepository.cleanup();
        this.fileIdempotentRepository.trunkStore();
        this.fileIdempotentRepository.stop();
        try (Stream<String> fileContent = Files.lines(fileStore.toPath());){
            List<String> fileEntries = fileContent.toList();
            Assertions.assertEquals((int)0, (int)fileEntries.size());
        }
    }
}

