/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultMaskingFormatterTest {
    @Test
    public void testDefaultOption() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter();
        String answer = formatter.format("key=value, myPassword=foo,\n myPassphrase=\"foo bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myPassword=xxxxx,\n myPassphrase=\"xxxxx\", secretKey='xxxxx'", (Object)answer);
        answer = formatter.format("<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<xmlPassword>\n xxxxx \n</xmlPassword>\n<user password=\"xxxxx\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"Password\":\"foo\", \"Passphrase\" : \"foo bar\", \"SecretKey\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"Password\":\"xxxxx\", \"Passphrase\" : \"xxxxx\", \"SecretKey\" : \"xxxxx\"}", (Object)answer);
    }

    @Test
    public void testDisableKeyValueMask() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter(false, true, true);
        String answer = formatter.format("key=value, myPassword=foo,\n myPassphrase=\"foo bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myPassword=foo,\n myPassphrase=\"foo bar\", secretKey='!@#$%^&*() -+[]{};:'", (Object)answer);
        answer = formatter.format("<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<xmlPassword>\n xxxxx \n</xmlPassword>\n<user password=\"asdf qwert\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"Password\":\"foo\", \"Passphrase\" : \"foo bar\", \"SecretKey\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"Password\":\"xxxxx\", \"Passphrase\" : \"xxxxx\", \"SecretKey\" : \"xxxxx\"}", (Object)answer);
    }

    @Test
    public void testDisableXmlElementMask() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter(true, false, true);
        String answer = formatter.format("key=value, myPassword=foo,\n myPassphrase=\"foo bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myPassword=xxxxx,\n myPassphrase=\"xxxxx\", secretKey='xxxxx'", (Object)answer);
        answer = formatter.format("<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"xxxxx\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"Password\":\"foo\", \"Passphrase\" : \"foo bar\", \"SecretKey\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"Password\":\"xxxxx\", \"Passphrase\" : \"xxxxx\", \"SecretKey\" : \"xxxxx\"}", (Object)answer);
    }

    @Test
    public void testDisableJsonMask() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter(true, true, false);
        String answer = formatter.format("key=value, myPassword=foo,\n myPassphrase=\"foo\u3000bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myPassword=xxxxx,\n myPassphrase=\"xxxxx\", secretKey='xxxxx'", (Object)answer);
        answer = formatter.format("<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<xmlPassword>\n xxxxx \n</xmlPassword>\n<user password=\"xxxxx\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"My Password\":\"foo\", \"My SecretPassphrase\" : \"foo bar\", \"My SecretKey2\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"My Password\":\"foo\", \"My SecretPassphrase\" : \"foo bar\", \"My SecretKey2\" : \"!@#$%^&*() -+[]{};:'\"}", (Object)answer);
    }

    @Test
    public void testCustomMaskString() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter();
        formatter.setMaskString("**********");
        String answer = formatter.format("key=value, myPassword=foo,\n myPassphrase=\"foo\u3000bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myPassword=**********,\n myPassphrase=\"**********\", secretKey='**********'", (Object)answer);
        answer = formatter.format("<xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<xmlPassword>\n ********** \n</xmlPassword>\n<user password=\"**********\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"Password\":\"foo\", \"Passphrase\" : \"foo bar\", \"SecretKey\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"Password\":\"**********\", \"Passphrase\" : \"**********\", \"SecretKey\" : \"**********\"}", (Object)answer);
    }

    @Test
    public void testDifferentSensitiveKeys() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter();
        String answer = formatter.format("key=value, myAccessKey=foo,\n authkey=\"foo bar\", refreshtoken='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, myAccessKey=xxxxx,\n authkey=\"xxxxx\", refreshtoken='xxxxx'", (Object)answer);
        answer = formatter.format("<subscribeKey>\n foo bar \n</subscribeKey>\n<user verificationCode=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<subscribeKey>\n xxxxx \n</subscribeKey>\n<user verificationCode=\"xxxxx\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"subscribeKey\":\"foo\", \"verificationCode\" : \"foo bar\", \"RefreshToken\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"subscribeKey\":\"xxxxx\", \"verificationCode\" : \"xxxxx\", \"RefreshToken\" : \"xxxxx\"}", (Object)answer);
    }

    @Test
    public void testCustomKeywords() {
        DefaultMaskingFormatter formatter = new DefaultMaskingFormatter();
        formatter.addKeyword("cheese");
        formatter.setMaskString("**********");
        String answer = formatter.format("key=value, Cheese=gauda, myPassword=foo,\n myPassphrase=\"foo\u3000bar\", secretKey='!@#$%^&*() -+[]{};:'");
        Assertions.assertEquals((Object)"key=value, Cheese=**********, myPassword=**********,\n myPassphrase=\"**********\", secretKey='**********'", (Object)answer);
        answer = formatter.format("<chEEse>Gauda</chEEse><xmlPassword>\n foo bar \n</xmlPassword>\n<user password=\"asdf qwert\"/>");
        Assertions.assertEquals((Object)"<chEEse>**********</chEEse><xmlPassword>\n ********** \n</xmlPassword>\n<user password=\"**********\"/>", (Object)answer);
        answer = formatter.format("{\"key\" : \"value\", \"Cheese\": \"gauda\", \"Password\":\"foo\", \"Passphrase\" : \"foo bar\", \"SecretKey\" : \"!@#$%^&*() -+[]{};:'\"}");
        Assertions.assertEquals((Object)"{\"key\" : \"value\", \"Cheese\": \"**********\", \"Password\":\"**********\", \"Passphrase\" : \"**********\", \"SecretKey\" : \"**********\"}", (Object)answer);
    }
}

