/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultExchangeFormatterTest {
    private DefaultCamelContext camelContext;
    private Exchange exchange;
    private DefaultExchangeFormatter exchangeFormatter;

    @BeforeEach
    public void setUp() {
        this.camelContext = new DefaultCamelContext();
        DefaultMessage message = new DefaultMessage((CamelContext)this.camelContext);
        message.setBody((Object)"This is the message body");
        this.exchange = new DefaultExchange((CamelContext)this.camelContext);
        this.exchange.setIn((Message)message);
        this.exchangeFormatter = new DefaultExchangeFormatter();
    }

    @Test
    public void testDefaultFormat() {
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assertions.assertTrue((boolean)formattedExchange.contains("This is the message body"));
    }

    @Test
    public void testFormatWithMaxCharsParameter() {
        this.exchangeFormatter.setMaxChars(60);
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assertions.assertEquals((int)(47 + "Exchange[...]".length() - ", ".length()), (int)formattedExchange.length());
    }

    @Test
    public void testFormatWithBodyMaxChars() {
        this.camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "7");
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assertions.assertFalse((boolean)formattedExchange.contains("This is "));
        Assertions.assertTrue((boolean)formattedExchange.contains("This is"));
        this.camelContext.getGlobalOptions().remove("CamelLogDebugBodyMaxChars");
    }

    @Test
    public void testFormatWithBoth() {
        this.camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "7");
        this.exchangeFormatter.setMaxChars(60);
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assertions.assertEquals((int)(60 + "Exchange[...]".length() - ", ".length()), (int)formattedExchange.length());
        Assertions.assertFalse((boolean)formattedExchange.contains("This is "));
        this.camelContext.getGlobalOptions().remove("CamelLogDebugBodyMaxChars");
    }
}

