/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.parallel.Isolated;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
@Isolated(value="This test is regularly flaky")
public class TrustManagersParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setResource("org/apache/camel/support/jsse/localhost.p12");
        ksp.setPassword("changeit");
        return ksp;
    }

    protected TrustManagersParameters createMinimalTrustManagersParameters() {
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setCamelContext((CamelContext)new DefaultCamelContext());
        tmp.setKeyStore(this.createMinimalKeyStoreParameters());
        return tmp;
    }

    @Test
    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParameters.password}}");
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setCamelContext(context);
        tmp.setKeyStore(ksp);
        tmp.setAlgorithm("{{trustManagersParameters.algorithm}}");
        tmp.setProvider("{{trustManagersParameters.provider}}");
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    @Test
    public void testCustomTrustManager() throws Exception {
        TrustManager myTm = new TrustManager(){};
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setTrustManager(myTm);
        TrustManager[] tms = tmp.createTrustManagers();
        Assertions.assertSame((Object)myTm, (Object)tms[0]);
    }

    @Test
    public void testCreateTrustManagers() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    @Test
    public void testExplicitAlgorithm() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    @Test
    public void testExplicitProvider() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setProvider(TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()).getProvider().getName());
        TrustManager[] tms = tmp.createTrustManagers();
        this.validateTrustManagers(tms);
    }

    @Test
    public void testInvalidExplicitAlgorithm() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setAlgorithm("dsfsdfsdfdsfdsF");
        try {
            tmp.createTrustManagers();
            Assertions.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidExplicitProvider() throws Exception {
        TrustManagersParameters tmp = this.createMinimalTrustManagersParameters();
        tmp.setProvider("dsfsdfsdfdsfdsF");
        try {
            tmp.createTrustManagers();
            Assertions.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    protected void validateTrustManagers(TrustManager[] tms) {
        Assertions.assertEquals((int)1, (int)tms.length);
        boolean b = tms[0] instanceof X509TrustManager;
        Assertions.assertTrue((boolean)b);
        X509TrustManager tm = (X509TrustManager)tms[0];
        Assertions.assertNotNull((Object)tm.getAcceptedIssuers());
    }
}

