/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.SecureRandomParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class SecureRandomParametersTest
extends AbstractJsseParametersTest {
    @Test
    public void testPropertyPlaceholders() throws Exception {
        if (this.canTest()) {
            CamelContext context = this.createPropertiesPlaceholderAwareContext();
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setCamelContext(context);
            srp.setAlgorithm("{{secureRandomParameters.algorithm}}");
            srp.setProvider("{{secureRandomParameters.provider}}");
            srp.createSecureRandom();
        }
    }

    @Test
    public void testCreateSecureRandom() throws Exception {
        if (this.canTest()) {
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setAlgorithm("SHA1PRNG");
            SecureRandom sr = srp.createSecureRandom();
            Assertions.assertEquals((Object)"SHA1PRNG", (Object)sr.getAlgorithm());
            String providerName = sr.getProvider().getName();
            srp.setProvider(providerName);
            sr = srp.createSecureRandom();
            Assertions.assertEquals((Object)"SHA1PRNG", (Object)sr.getAlgorithm());
            Assertions.assertEquals((Object)providerName, (Object)sr.getProvider().getName());
        }
    }

    @Test
    public void testExplicitInvalidAlgorithm() throws Exception {
        SecureRandomParameters srp = new SecureRandomParameters();
        srp.setAlgorithm("fsafsadfasdfasdf");
        try {
            srp.createSecureRandom();
            Assertions.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Test
    public void testExplicitInvalidProvider() throws Exception {
        if (this.canTest()) {
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setAlgorithm("SHA1PRNG");
            srp.setProvider("asdfsadfasdfasdf");
            try {
                srp.createSecureRandom();
                Assertions.fail();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
        }
    }

    protected boolean canTest() {
        try {
            SecureRandom.getInstance("SHA1PRNG");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }
}

