/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.apache.camel.support.jsse.FilterParameters;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextClientParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class SSLContextParametersTest
extends AbstractJsseParametersTest {
    @Test
    public void testFilter() {
        SSLContextParameters parameters = new SSLContextParameters();
        Collection result = parameters.filter(null, Arrays.asList("SSLv3", "TLSv1", "TLSv1.1"), List.of(Pattern.compile("TLS.*")), List.of());
        Assertions.assertEquals((int)2, (int)result.size());
        this.assertStartsWith(result, "TLS");
        result = parameters.filter(null, Arrays.asList("SSLv3", "TLSv1", "TLSv1.1"), List.of(Pattern.compile(".*")), List.of(Pattern.compile("SSL.*")));
        Assertions.assertEquals((int)2, (int)result.size());
        this.assertStartsWith(result, "TLS");
        AssertionError error = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertStartsWith((String[])null, "TLS"), (String)"We should got an exception here!"));
        Assertions.assertTrue((boolean)((Throwable)((Object)error)).getMessage().contains("The values should not be null"), (String)"Get a wrong message");
    }

    @Test
    public void testPropertyPlaceholders() throws Exception {
        CamelContext camelContext = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(camelContext);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParameters.password}}");
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext(camelContext);
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword("{{keyManagersParameters.keyPassword}}");
        kmp.setAlgorithm("{{keyManagersParameters.algorithm}}");
        kmp.setProvider("{{keyManagersParameters.provider}}");
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setCamelContext(camelContext);
        tmp.setKeyStore(ksp);
        tmp.setAlgorithm("{{trustManagersParameters.algorithm}}");
        tmp.setProvider("{{trustManagersParameters.provider}}");
        CipherSuitesParameters csp = new CipherSuitesParameters();
        csp.setCipherSuite(Collections.singletonList("{{cipherSuite.0}}"));
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        sspp.setSecureSocketProtocol(Collections.singletonList("{{secureSocketProtocol.0}}"));
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scsp.setCamelContext(camelContext);
        scsp.setClientAuthentication("{{sslContextServerParameters.clientAuthentication}}");
        SSLContextParameters scp = new SSLContextParameters();
        scp.setCamelContext(camelContext);
        scp.setKeyManagers(kmp);
        scp.setTrustManagers(tmp);
        scp.setServerParameters(scsp);
        scp.setProvider("{{sslContextParameters.provider}}");
        scp.setSecureSocketProtocol("{{sslContextParameters.protocol}}");
        scp.setSessionTimeout("{{sslContextParameters.sessionTimeout}}");
        scp.setCipherSuites(csp);
        scp.setSecureSocketProtocols(sspp);
        SSLContext context = scp.createSSLContext(null);
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertTrue((boolean)serverSocket.getNeedClientAuth());
        context.getSocketFactory().createSocket();
        context.createSSLEngine();
    }

    @Test
    public void testServerParametersClientAuthentication() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scp.setServerParameters(scsp);
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((Object)controlServerSocket.getWantClientAuth(), (Object)serverSocket.getWantClientAuth());
        Assertions.assertEquals((Object)controlServerSocket.getNeedClientAuth(), (Object)serverSocket.getNeedClientAuth());
        Assertions.assertEquals((Object)controlEngine.getWantClientAuth(), (Object)engine.getWantClientAuth());
        Assertions.assertEquals((Object)controlEngine.getNeedClientAuth(), (Object)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.NONE.name());
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertFalse((boolean)serverSocket.getWantClientAuth());
        Assertions.assertFalse((boolean)serverSocket.getNeedClientAuth());
        Assertions.assertFalse((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.WANT.name());
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertTrue((boolean)serverSocket.getWantClientAuth());
        Assertions.assertFalse((boolean)serverSocket.getNeedClientAuth());
        Assertions.assertTrue((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.REQUIRE.name());
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertFalse((boolean)serverSocket.getWantClientAuth());
        Assertions.assertTrue((boolean)serverSocket.getNeedClientAuth());
        Assertions.assertFalse((boolean)engine.getWantClientAuth());
        Assertions.assertTrue((boolean)engine.getNeedClientAuth());
    }

    @Test
    public void testServerParameters() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLSv1.3");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scp.setServerParameters(scsp);
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        Assertions.assertEquals((Object)controlServerSocket.getWantClientAuth(), (Object)serverSocket.getWantClientAuth());
        Assertions.assertEquals((Object)controlServerSocket.getNeedClientAuth(), (Object)serverSocket.getNeedClientAuth());
        scp.setCipherSuites(new CipherSuitesParameters());
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        scp.setCipherSuites(null);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scsp.setCipherSuites(csp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add(".*");
        scsp.setCipherSuites(null);
        scsp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        scsp.setCipherSuites(csp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        scsp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter = new FilterParameters();
        filter.getExclude().add(".*");
        scsp.setSecureSocketProtocols(null);
        scsp.setSecureSocketProtocolsFilter(filter);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        scsp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        scsp.setSessionTimeout("12345");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)controlContext.getClientSessionContext().getSessionTimeout(), (int)context.getClientSessionContext().getSessionTimeout());
        Assertions.assertEquals((int)12345, (int)context.getServerSessionContext().getSessionTimeout());
    }

    private void checkProtocols(String[] control, String[] configured) {
        Assertions.assertTrue((boolean)Arrays.asList(configured).containsAll(Arrays.asList(control)));
    }

    @Test
    public void testClientParameters() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLSv1.3");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextClientParameters sccp = new SSLContextClientParameters();
        scp.setClientParameters(sccp);
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        scp.setCipherSuites(new CipherSuitesParameters());
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        scp.setCipherSuites(null);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        sccp.setCipherSuites(csp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add(".*");
        sccp.setCipherSuites(null);
        sccp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        sccp.setCipherSuites(csp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        sccp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        filter = new FilterParameters();
        filter.getExclude().add(".*");
        sccp.setSecureSocketProtocols(null);
        sccp.setSecureSocketProtocolsFilter(filter);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        sccp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        sccp.setSessionTimeout("12345");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)controlContext.getServerSessionContext().getSessionTimeout(), (int)context.getServerSessionContext().getSessionTimeout());
        Assertions.assertEquals((int)12345, (int)context.getClientSessionContext().getSessionTimeout());
    }

    @Test
    public void testCipherSuites() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLSv1.3");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scp.setCipherSuites(csp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        csp.setCipherSuite(Collections.singletonList(controlEngine.getEnabledCipherSuites()[0]));
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)1, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)engine.getEnabledCipherSuites()[0]);
        Assertions.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)socket.getEnabledCipherSuites()[0]);
        Assertions.assertEquals((int)1, (int)serverSocket.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)serverSocket.getEnabledCipherSuites()[0]);
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add(".*");
        scp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)1, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)engine.getEnabledCipherSuites()[0]);
        Assertions.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)socket.getEnabledCipherSuites()[0]);
        Assertions.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((Object)controlEngine.getEnabledCipherSuites()[0], (Object)serverSocket.getEnabledCipherSuites()[0]);
    }

    @Test
    public void testCipherSuitesFilter() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLSv1.3");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext(null);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scp.setCipherSuites(csp);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledCipherSuites(), (Object[])engine.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledCipherSuites(), (Object[])socket.getEnabledCipherSuites());
        Assertions.assertArrayEquals((Object[])this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), (Object[])serverSocket.getEnabledCipherSuites());
        FilterParameters filter = new FilterParameters();
        scp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().add(".*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getExclude().add(".*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().clear();
        filter.getExclude().clear();
        csp.setCipherSuite(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA"));
        filter.getInclude().add("TLS.*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            Assertions.assertTrue((engine.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(engine.getEnabledCipherSuites(), "TLS");
            Assertions.assertTrue((socket.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(socket.getEnabledCipherSuites(), "TLS");
            Assertions.assertTrue((serverSocket.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(serverSocket.getEnabledCipherSuites(), "TLS");
        }
    }

    @Test
    public void testSecureSocketProtocols() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        scp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        sspp.setSecureSocketProtocol(Collections.singletonList("TLSv1"));
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)1, (int)engine.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"TLSv1", (Object)engine.getEnabledProtocols()[0]);
        Assertions.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"TLSv1", (Object)socket.getEnabledProtocols()[0]);
        Assertions.assertEquals((int)1, (int)serverSocket.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"TLSv1", (Object)serverSocket.getEnabledProtocols()[0]);
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add(".*");
        scp.setSecureSocketProtocolsFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            Assertions.assertEquals((int)1, (int)engine.getEnabledProtocols().length);
            Assertions.assertEquals((Object)"TLSv1", (Object)engine.getEnabledProtocols()[0]);
            Assertions.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
            Assertions.assertEquals((Object)"TLSv1", (Object)socket.getEnabledProtocols()[0]);
            Assertions.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
            Assertions.assertEquals((Object)"TLSv1", (Object)serverSocket.getEnabledProtocols()[0]);
        }
    }

    @Test
    public void testSecureSocketProtocolsFilter() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLSv1.3");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext(null);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        FilterParameters filter = new FilterParameters();
        scp.setSecureSocketProtocolsFilter(filter);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().add(".*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertArrayEquals((Object[])controlEngine.getEnabledProtocols(), (Object[])engine.getEnabledProtocols());
        Assertions.assertArrayEquals((Object[])controlSocket.getEnabledProtocols(), (Object[])socket.getEnabledProtocols());
        this.checkProtocols(controlServerSocket.getEnabledProtocols(), serverSocket.getEnabledProtocols());
        filter.getExclude().add(".*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        Assertions.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().clear();
        filter.getExclude().clear();
        filter.getInclude().add("TLS.*");
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            Assertions.assertTrue((engine.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
            Assertions.assertTrue((socket.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
            Assertions.assertTrue((socket.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        }
    }

    @Test
    public void testSessionTimeout() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.setSessionTimeout("60");
        SSLContext context = scp.createSSLContext(null);
        Assertions.assertEquals((int)60, (int)context.getClientSessionContext().getSessionTimeout());
        Assertions.assertEquals((int)60, (int)context.getServerSessionContext().getSessionTimeout());
        scp.setSessionTimeout("0");
        context = scp.createSSLContext(null);
        Assertions.assertEquals((int)0, (int)context.getClientSessionContext().getSessionTimeout());
        Assertions.assertEquals((int)0, (int)context.getServerSessionContext().getSessionTimeout());
    }

    @Test
    public void testDefaultSecureSocketProtocol() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext(null);
        Assertions.assertEquals((Object)"TLSv1.3", (Object)context.getProtocol());
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
    }

    @Test
    public void testSecureSocketProtocol() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.setSecureSocketProtocol("SSLv3");
        SSLContext context = scp.createSSLContext(null);
        Assertions.assertEquals((Object)"SSLv3", (Object)context.getProtocol());
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        SecureSocketProtocolsParameters protocols = new SecureSocketProtocolsParameters();
        protocols.setSecureSocketProtocol(Collections.singletonList("SSLv3"));
        scp.setSecureSocketProtocols(protocols);
        context = scp.createSSLContext(null);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        Assertions.assertEquals((int)1, (int)engine.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"SSLv3", (Object)engine.getEnabledProtocols()[0]);
        Assertions.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"SSLv3", (Object)socket.getEnabledProtocols()[0]);
        Assertions.assertEquals((int)1, (int)serverSocket.getEnabledProtocols().length);
        Assertions.assertEquals((Object)"SSLv3", (Object)serverSocket.getEnabledProtocols()[0]);
    }

    @Test
    public void testProvider() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.createSSLContext(null);
        SSLContext context = scp.createSSLContext(null);
        SSLContext defaultContext = SSLContext.getDefault();
        Assertions.assertEquals((Object)defaultContext.getProvider().getName(), (Object)context.getProvider().getName());
    }

    protected String[] getDefaultCipherSuiteIncludes(String[] availableCipherSuites) {
        LinkedList<String> enabled = new LinkedList<String>();
        for (String string : availableCipherSuites) {
            if (string.contains("_anon_") || string.contains("_NULL_") || string.contains("_EXPORT_") || string.contains("_DES_")) continue;
            enabled.add(string);
        }
        return enabled.toArray(new String[0]);
    }

    protected void assertStartsWith(String[] values, String prefix) {
        Assertions.assertNotNull((Object)values, (String)"The values should not be null");
        for (String value : values) {
            Assertions.assertTrue((boolean)value.startsWith(prefix), (String)(value + " does not start with the prefix " + prefix));
        }
    }

    protected void assertStartsWith(Collection<String> values, String prefix) {
        Assertions.assertNotNull(values, (String)"The values should not be null");
        for (String value : values) {
            Assertions.assertTrue((boolean)value.startsWith(prefix), (String)(value + " does not start with the prefix " + prefix));
        }
    }
}

