/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class KeyStoreParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource("org/apache/camel/support/jsse/localhost.p12");
        ksp.setPassword("changeit");
        return ksp;
    }

    @Test
    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParameters.password}}");
        KeyStore ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
    }

    @Test
    public void testValidParameters() throws GeneralSecurityException, IOException, URISyntaxException {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        KeyStore ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
        URL resourceUrl = this.getClass().getResource("/org/apache/camel/support/jsse/localhost.p12");
        ksp.setResource(resourceUrl.toExternalForm());
        ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
        resourceUrl = this.getClass().getResource("/org/apache/camel/support/jsse/localhost.p12");
        File file = new File(resourceUrl.toURI());
        ksp.setResource("file:" + file.getAbsolutePath());
        ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
    }

    @Test
    public void testExplicitType() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setType("jks");
        KeyStore ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
    }

    @Test
    public void testExplicitProvider() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setProvider(ksp.createKeyStore().getProvider().getName());
        KeyStore ks = ksp.createKeyStore();
        Assertions.assertNotNull((Object)ks.getCertificate("localhost"));
    }

    @Test
    public void testExplicitInvalidProvider() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setProvider("sdfdsfgfdsgdsfg");
        try {
            ksp.createKeyStore();
            Assertions.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testExplicitInvalidType() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setType("1234");
        try {
            ksp.createKeyStore();
            Assertions.fail();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setPassword("");
        try {
            ksp.createKeyStore();
            Assertions.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testIncorrectResource() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setResource("");
        try {
            ksp.createKeyStore();
            Assertions.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

