/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.AliasedX509ExtendedKeyManager;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class KeyManagersParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext((CamelContext)new DefaultCamelContext());
        ksp.setResource("org/apache/camel/support/jsse/localhost.p12");
        ksp.setPassword("changeit");
        ksp.setType("PKCS12");
        return ksp;
    }

    protected KeyManagersParameters createMinimalKeyManagersParameters() {
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext((CamelContext)new DefaultCamelContext());
        kmp.setKeyStore(this.createMinimalKeyStoreParameters());
        kmp.setKeyPassword("changeit");
        return kmp;
    }

    @Test
    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParameters.password}}");
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext(context);
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword("{{keyManagersParameters.keyPassword}}");
        kmp.setAlgorithm("{{keyManagersParameters.algorithm}}");
        kmp.setProvider("{{keyManagersParameters.provider}}");
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    @Test
    public void testCreateKeyManagers() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    @Test
    public void testExplicitAlgorithm() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    @Test
    public void testExplicitProvider() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setProvider(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()).getProvider().getName());
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    @Test
    public void testInvalidPassword() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setKeyPassword("");
        try {
            kmp.createKeyManagers();
            Assertions.fail();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidExplicitAlgorithm() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setAlgorithm("dsfsdfsdfdsfdsF");
        try {
            kmp.createKeyManagers();
            Assertions.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidExplicitProvider() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setProvider("dsfsdfsdfdsfdsF");
        try {
            kmp.createKeyManagers();
            Assertions.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    @Test
    public void testAliasedKeyManager() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        KeyManager[] kms = kmp.createKeyManagers();
        Assertions.assertEquals((int)1, (int)kms.length);
        boolean b = kms[0] instanceof X509KeyManager;
        Assertions.assertTrue((boolean)b);
        kms[0] = new AliasedX509ExtendedKeyManager("localhost", (X509KeyManager)kms[0]);
        AliasedX509ExtendedKeyManager km = (AliasedX509ExtendedKeyManager)kms[0];
        Assertions.assertNotNull((Object)km.getPrivateKey("localhost"));
    }

    protected void validateKeyManagers(KeyManager[] kms) {
        Assertions.assertEquals((int)1, (int)kms.length);
        boolean b = kms[0] instanceof X509KeyManager;
        Assertions.assertTrue((boolean)b);
        X509KeyManager km = (X509KeyManager)kms[0];
        Assertions.assertNotNull((Object)km.getPrivateKey("localhost"));
    }
}

