/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.AbstractJsseParametersTest;
import org.apache.camel.support.jsse.FilterParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class FilterParametersTest
extends AbstractJsseParametersTest {
    @Test
    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        FilterParameters filter = new FilterParameters();
        filter.setCamelContext(context);
        filter.getInclude().add("{{filterParameters.include}}");
        filter.getExclude().add("{{filterParameters.exclude}}");
        FilterParameters.Patterns patterns = filter.getPatterns();
        List includes = patterns.getIncludes();
        List excludes = patterns.getExcludes();
        Assertions.assertNotNull((Object)includes);
        Assertions.assertNotNull((Object)excludes);
        Assertions.assertEquals((int)1, (int)includes.size());
        Assertions.assertEquals((int)1, (int)excludes.size());
        Matcher includeMatcher = ((Pattern)includes.get(0)).matcher("include");
        Assertions.assertTrue((boolean)includeMatcher.matches());
        Matcher excludeMatcher = ((Pattern)excludes.get(0)).matcher("exclude");
        Assertions.assertTrue((boolean)excludeMatcher.matches());
    }

    @Test
    public void testGetIncludePatterns() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add("asdfsadfsadfsadf");
        List includes = filter.getIncludePatterns();
        List excludes = filter.getExcludePatterns();
        Assertions.assertNotNull((Object)includes);
        Assertions.assertEquals((int)1, (int)includes.size());
        Assertions.assertNotNull((Object)excludes);
        Assertions.assertEquals((int)0, (int)excludes.size());
        Assertions.assertNotNull(includes.get(0));
        Matcher matcher = ((Pattern)includes.get(0)).matcher("asdfsadfsadfsadf");
        Assertions.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testGetExcludePatterns() {
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add("asdfsadfsadfsadf");
        List includes = filter.getIncludePatterns();
        List excludes = filter.getExcludePatterns();
        Assertions.assertNotNull((Object)excludes);
        Assertions.assertEquals((int)1, (int)excludes.size());
        Assertions.assertNotNull((Object)includes);
        Assertions.assertEquals((int)0, (int)includes.size());
        Assertions.assertNotNull(excludes.get(0));
        Matcher matcher = ((Pattern)excludes.get(0)).matcher("asdfsadfsadfsadf");
        Assertions.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void test() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add("asdf.*");
        filter.getExclude().add("aa");
        FilterParameters.Patterns patterns = filter.getPatterns();
        List includes = patterns.getIncludes();
        List excludes = patterns.getExcludes();
        Assertions.assertNotNull((Object)includes);
        Assertions.assertNotNull((Object)excludes);
        Assertions.assertEquals((int)1, (int)includes.size());
        Assertions.assertEquals((int)1, (int)excludes.size());
        Matcher includeMatcher = ((Pattern)includes.get(0)).matcher("asdfsadfsadfsadf");
        Assertions.assertTrue((boolean)includeMatcher.matches());
        Matcher excludeMatcher = ((Pattern)excludes.get(0)).matcher("aa");
        Assertions.assertTrue((boolean)excludeMatcher.matches());
    }
}

