/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jndi;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.TestSupport;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JndiTest
extends TestSupport {
    protected Context context;

    public static Context createInitialContext() throws Exception {
        InputStream in = JndiTest.class.getClassLoader().getResourceAsStream("jndi-example.properties");
        try {
            Assertions.assertNotNull((Object)in, (String)"Cannot find jndi-example.properties on the classpath!");
            Properties properties = new Properties();
            properties.load(in);
            InitialContext initialContext = new InitialContext(new Hashtable<Object, Object>(properties));
            return initialContext;
        }
        finally {
            IOHelper.close((Closeable)in);
        }
    }

    @Test
    public void testLookupOfSimpleName() throws Exception {
        Object value = this.assertLookup("foo");
        Assertions.assertEquals((Object)"bar", (Object)value, (String)"foo");
    }

    protected Object assertLookup(String name) throws NamingException {
        Object value = this.context.lookup(name);
        Assertions.assertNotNull((Object)value, (String)("Should have found JNDI entry: " + name + " in context: " + String.valueOf(this.context)));
        return value;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = JndiTest.createInitialContext();
    }
}

