/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jndi.CamelSingletonInitialContextFactory;
import org.apache.camel.support.jndi.JndiBeanRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JndiCamelSingletonInitialContextFactoryTest
extends ContextTestSupport {
    private static final String FAKE = "!!! Get DataSource fake !!!";
    private final Hashtable<String, String> env = new Hashtable();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.env.put("java.naming.factory.initial", CamelSingletonInitialContextFactory.class.getName());
        super.setUp();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        InitialContext context = new InitialContext(this.env);
        context.bind("jdbc/myDataSource", (Object)FAKE);
        return new DefaultRegistry(new BeanRepository[]{new JndiBeanRepository((Context)context)});
    }

    @Test
    public void testSingletonJndiContext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{FAKE});
        this.template.sendBody("direct:simple", (Object)"Dummy");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:simple").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        InitialContext context = new InitialContext(JndiCamelSingletonInitialContextFactoryTest.this.env);
                        exchange.getIn().setBody((Object)context.lookup("jdbc/myDataSource").toString());
                    }
                })).to("mock:result");
            }
        };
    }
}

