/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.component.RawParameterHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RawParameterHelperTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testResolveRawParameterValues() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", "abc");
        map.put("password", "RAW(sec*ret)");
        RawParameterHelper.resolveRawParameterValues((CamelContext)this.context, map);
        Assertions.assertEquals((Object)"abc", map.get("username"));
        Assertions.assertEquals((Object)"sec*ret", map.get("password"));
        map.put("password", "RAW($simple{camelId})");
        RawParameterHelper.resolveRawParameterValues((CamelContext)this.context, map);
        Assertions.assertEquals((Object)"abc", map.get("username"));
        Assertions.assertEquals((Object)this.context.getName(), map.get("password"));
        String usr = System.getenv("USER");
        if (usr != null) {
            map.put("password", "RAW($simple{env:USER})");
            RawParameterHelper.resolveRawParameterValues((CamelContext)this.context, map);
            Assertions.assertEquals((Object)"abc", map.get("username"));
            Assertions.assertEquals((Object)usr, map.get("password"));
        }
    }
}

