/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodParser;
import org.apache.camel.support.component.ArgumentSubstitutionParser;
import org.apache.camel.support.component.TestProxy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArgumentSubstitutionParserTest {
    private static final String PERSON = "person";

    @Test
    public void testParse() {
        ArgumentSubstitutionParser.Substitution[] adapters = new ArgumentSubstitutionParser.Substitution[]{new ArgumentSubstitutionParser.Substitution(".+", "name", PERSON), new ArgumentSubstitutionParser.Substitution("greet.+", "person([0-9]+)", "astronaut$1"), new ArgumentSubstitutionParser.Substitution(".+", "(.+)", "java.util.List", "$1List"), new ArgumentSubstitutionParser.Substitution(".+", "(.+)", ".*?(\\w++)\\[\\]", "$1Array", true)};
        ApiMethodParser<TestProxy> parser = ArgumentSubstitutionParserTest.getTestProxyApiMethodParser(adapters);
        List methodModels = parser.parse();
        Assertions.assertEquals((int)9, (int)methodModels.size());
        ApiMethodParser.ApiMethodModel sayHi1 = (ApiMethodParser.ApiMethodModel)methodModels.get(8);
        Assertions.assertEquals((Object)PERSON, (Object)((ApiMethodArg)sayHi1.getArguments().get(0)).getName());
        Assertions.assertEquals((Object)"SAY_HI_1", (Object)sayHi1.getUniqueName());
        ApiMethodParser.ApiMethodModel greetMe = (ApiMethodParser.ApiMethodModel)methodModels.get(4);
        Assertions.assertEquals((Object)PERSON, (Object)((ApiMethodArg)greetMe.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetUs = (ApiMethodParser.ApiMethodModel)methodModels.get(6);
        Assertions.assertEquals((Object)"astronaut1", (Object)((ApiMethodArg)greetUs.getArguments().get(0)).getName());
        Assertions.assertEquals((Object)"astronaut2", (Object)((ApiMethodArg)greetUs.getArguments().get(1)).getName());
        ApiMethodParser.ApiMethodModel greetAll = (ApiMethodParser.ApiMethodModel)methodModels.get(0);
        Assertions.assertEquals((Object)"personList", (Object)((ApiMethodArg)greetAll.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetAll1 = (ApiMethodParser.ApiMethodModel)methodModels.get(1);
        Assertions.assertEquals((Object)"personMap", (Object)((ApiMethodArg)greetAll1.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetAll2 = (ApiMethodParser.ApiMethodModel)methodModels.get(2);
        Assertions.assertEquals((Object)"stringArray", (Object)((ApiMethodArg)greetAll2.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetInnerChild = (ApiMethodParser.ApiMethodModel)methodModels.get(3);
        Assertions.assertEquals((Object)"child", (Object)((ApiMethodArg)greetInnerChild.getArguments().get(0)).getName());
    }

    private static ApiMethodParser<TestProxy> getTestProxyApiMethodParser(ArgumentSubstitutionParser.Substitution[] adapters) {
        ArgumentSubstitutionParser parser = new ArgumentSubstitutionParser(TestProxy.class, adapters);
        ArrayList<String> signatures = new ArrayList<String>();
        signatures.add("public String sayHi();");
        signatures.add("public String sayHi(final String name);");
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        args.put("name", "java.lang.String");
        parser.addSignatureArguments("String sayHi(String name);", args);
        signatures.add("public final String greetMe(final String name);");
        args = new LinkedHashMap();
        args.put("name", "java.lang.String");
        parser.addSignatureArguments("String greetMe(String name);", args);
        signatures.add("public final String greetUs(final String name1, String name2);");
        args = new LinkedHashMap();
        args.put("name1", "java.lang.String");
        args.put("name2", "java.lang.String");
        parser.addSignatureArguments("String greetUs(String name1, String name2);", args);
        signatures.add("public final String greetAll(String[] names);");
        args = new LinkedHashMap();
        args.put("name", "java.lang.String[]");
        parser.addSignatureArguments("String greetAll(String[] names);", args);
        signatures.add("public final String greetAll(java.util.List<String> names);");
        args = new LinkedHashMap();
        args.put("name", "java.util.List<String>");
        parser.addSignatureArguments("String greetAll(java.util.List<String> names);", args);
        signatures.add("public final java.util.Map<String, String> greetAll(java.util.Map<String> nameMap);");
        args = new LinkedHashMap();
        args.put("nameMap", "java.util.Map<String>");
        parser.addSignatureArguments("java.util.Map<String, String> greetAll(java.util.Map<String> nameMap);", args);
        signatures.add("public final String[] greetTimes(String name, int times);");
        args = new LinkedHashMap();
        args.put("name", "java.lang.String");
        args.put("times", "int");
        parser.addSignatureArguments("String[] greetTimes(String name, int times);", args);
        signatures.add("public final String greetInnerChild(org.apache.camel.support.component.TestProxy.InnerChild child);");
        args = new LinkedHashMap();
        args.put("child", "org.apache.camel.support.component.TestProxy$InnerChild");
        parser.addSignatureArguments("String greetInnerChild(org.apache.camel.support.component.TestProxy.InnerChild child);", args);
        parser.setSignatures(signatures);
        return parser;
    }
}

