/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ApiMethodPropertiesHelperTest {
    private static final String TEST_PREFIX = "CamelTest.";
    private static final String PROPERTY_1 = "CamelTest.property1";
    private static final String PROPERTY_2 = "CamelTest.property2";
    private static final String PROPERTY_3 = "CamelTest.property3";
    private static final String PROPERTY_4 = "CamelTest.property4";
    private static final String PROPERTY_5 = "CamelTest.".substring(0, "CamelTest.".length() - 1) + "Property5";
    private static final String VALUE_1 = "value1";
    private static final long VALUE_2 = 2L;
    private static final String VALUE_3 = "value3";
    private static final String VALUE_4 = "true";
    private static final String VALUE_5 = "CamelCaseValue";
    private static final ApiMethodPropertiesHelper<TestComponentConfiguration> propertiesHelper = new ApiMethodPropertiesHelper<TestComponentConfiguration>((CamelContext)new DefaultCamelContext(), TestComponentConfiguration.class, "CamelTest."){};

    @Test
    public void testGetExchangeProperties() {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        MockEndpoint mock = new MockEndpoint(null, (Component)new MockComponent((CamelContext)camelContext));
        HashMap properties = new HashMap();
        DefaultExchange exchange = DefaultExchange.newFromEndpoint((Endpoint)mock);
        exchange.getIn().setHeader(PROPERTY_1, (Object)VALUE_1);
        exchange.getIn().setHeader(PROPERTY_2, (Object)2L);
        exchange.getIn().setHeader(PROPERTY_3, (Object)VALUE_3);
        exchange.getIn().setHeader(PROPERTY_4, (Object)VALUE_4);
        exchange.getIn().setHeader(PROPERTY_5, (Object)VALUE_5);
        propertiesHelper.getExchangeProperties((Exchange)exchange, properties);
        Assertions.assertEquals((int)5, (int)properties.size());
    }

    @Test
    public void testGetEndpointProperties() {
        HashMap properties = new HashMap();
        TestEndpointConfiguration endpointConfiguration = new TestEndpointConfiguration();
        endpointConfiguration.setProperty1(VALUE_1);
        endpointConfiguration.setProperty2(2L);
        endpointConfiguration.setProperty3(VALUE_3);
        endpointConfiguration.setProperty4(Boolean.valueOf(VALUE_4));
        propertiesHelper.getEndpointProperties((CamelContext)new DefaultCamelContext(), (Object)endpointConfiguration, properties);
        Assertions.assertEquals((int)2, (int)properties.size());
    }

    @Test
    public void testGetEndpointPropertyNames() {
        TestEndpointConfiguration endpointConfiguration = new TestEndpointConfiguration();
        endpointConfiguration.setProperty1(VALUE_1);
        endpointConfiguration.setProperty4(Boolean.valueOf(VALUE_4));
        Assertions.assertEquals((int)1, (int)propertiesHelper.getEndpointPropertyNames((CamelContext)new DefaultCamelContext(), (Object)endpointConfiguration).size());
    }

    @Test
    public void testGetValidEndpointProperties() {
        Assertions.assertEquals((int)2, (int)propertiesHelper.getValidEndpointProperties((CamelContext)new DefaultCamelContext(), (Object)new TestEndpointConfiguration()).size());
    }

    private static class TestEndpointConfiguration
    extends TestComponentConfiguration {
        private String property3;
        private Boolean property4;

        private TestEndpointConfiguration() {
        }

        public String getProperty3() {
            return this.property3;
        }

        public void setProperty3(String property3) {
            this.property3 = property3;
        }

        public Boolean getProperty4() {
            return this.property4;
        }

        public void setProperty4(Boolean property4) {
            this.property4 = property4;
        }
    }

    private static class TestComponentConfiguration {
        private String property1;
        private Long property2;

        private TestComponentConfiguration() {
        }

        public String getProperty1() {
            return this.property1;
        }

        public void setProperty1(String property1) {
            this.property1 = property1;
        }

        public long getProperty2() {
            return this.property2;
        }

        public void setProperty2(Long property2) {
            this.property2 = property2;
        }
    }
}

