/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.ApiMethodImpl;
import org.apache.camel.support.component.TestProxy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ApiMethodHelperTest {
    private static final TestMethod[] sayHis = new TestMethod[]{TestMethod.SAYHI, TestMethod.SAYHI_1};
    private static final ApiMethodHelper<TestMethod> apiMethodHelper;

    @Test
    public void testGetCandidateMethods() {
        List methods = apiMethodHelper.getCandidateMethods("sayHi");
        Assertions.assertEquals((int)2, (int)methods.size(), (String)"Can't find sayHi(*)");
        methods = apiMethodHelper.getCandidateMethods("hi");
        Assertions.assertEquals((int)2, (int)methods.size(), (String)"Can't find sayHi(name)");
        methods = apiMethodHelper.getCandidateMethods("hi", List.of("name"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Can't find sayHi(name)");
        methods = apiMethodHelper.getCandidateMethods("greetMe");
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Can't find greetMe(name)");
        methods = apiMethodHelper.getCandidateMethods("greetUs", List.of("name1"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Can't find greetUs(name1, name2)");
        methods = apiMethodHelper.getCandidateMethods("greetAll", List.of("nameMap"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Can't find greetAll(nameMap)");
        methods = apiMethodHelper.getCandidateMethods("greetInnerChild", List.of("child"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Can't find greetInnerChild(child)");
    }

    @Test
    public void testFilterMethods() {
        List methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.EXACT);
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Exact match failed for sayHi()");
        Assertions.assertEquals((Object)((Object)TestMethod.SAYHI), methods.get(0), (String)"Exact match failed for sayHi()");
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUBSET);
        Assertions.assertEquals((int)2, (int)methods.size(), (String)"Subset match failed for sayHi(*)");
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUBSET, List.of("name"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Subset match failed for sayHi(name)");
        Assertions.assertEquals((Object)((Object)TestMethod.SAYHI_1), methods.get(0), (String)"Exact match failed for sayHi()");
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUPER_SET, List.of("name"));
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Super set match failed for sayHi(name)");
        Assertions.assertEquals((Object)((Object)TestMethod.SAYHI_1), methods.get(0), (String)"Exact match failed for sayHi()");
        methods = apiMethodHelper.filterMethods(Arrays.asList(TestMethod.values()), ApiMethodHelper.MatchType.SUPER_SET, List.of("name"));
        Assertions.assertEquals((int)2, (int)methods.size(), (String)"Super set match failed for sayHi(name)");
        methods = apiMethodHelper.filterMethods(Arrays.asList(TestMethod.GREETALL, TestMethod.GREETALL_1, TestMethod.GREETALL_2), ApiMethodHelper.MatchType.SUPER_SET);
        Assertions.assertEquals((int)1, (int)methods.size(), (String)"Super set match with null args failed for greetAll(names)");
    }

    @Test
    public void testGetArguments() {
        Assertions.assertEquals((int)2, (int)apiMethodHelper.getArguments("hi").size(), (String)"GetArguments failed for hi");
        Assertions.assertEquals((int)2, (int)apiMethodHelper.getArguments("greetMe").size(), (String)"GetArguments failed for greetMe");
        Assertions.assertEquals((int)4, (int)apiMethodHelper.getArguments("greetUs").size(), (String)"GetArguments failed for greetUs");
        Assertions.assertEquals((int)6, (int)apiMethodHelper.getArguments("greetAll").size(), (String)"GetArguments failed for greetAll");
        Assertions.assertEquals((int)2, (int)apiMethodHelper.getArguments("greetInnerChild").size(), (String)"GetArguments failed for greetInnerChild");
    }

    @Test
    public void testGetMissingProperties() {
        Assertions.assertEquals((int)1, (int)apiMethodHelper.getMissingProperties("hi", new HashSet()).size(), (String)"Missing properties for hi");
        HashSet<String> argNames = new HashSet<String>();
        argNames.add("name");
        Assertions.assertEquals((int)0, (int)apiMethodHelper.getMissingProperties("greetMe", argNames).size(), (String)"Missing properties for greetMe");
        argNames.clear();
        argNames.add("name1");
        Assertions.assertEquals((int)1, (int)apiMethodHelper.getMissingProperties("greetUs", argNames).size(), (String)"Missing properties for greetMe");
    }

    @Test
    public void testAllArguments() {
        Assertions.assertEquals((int)8, (int)apiMethodHelper.allArguments().size(), (String)"Get all arguments");
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals(String.class, (Object)apiMethodHelper.getType("name"), (String)"Get type name");
        Assertions.assertEquals(String.class, (Object)apiMethodHelper.getType("name1"), (String)"Get type name1");
        Assertions.assertEquals(String.class, (Object)apiMethodHelper.getType("name2"), (String)"Get type name2");
        Assertions.assertEquals(Map.class, (Object)apiMethodHelper.getType("nameMap"), (String)"Get type nameMap");
        Assertions.assertEquals(TestProxy.InnerChild.class, (Object)apiMethodHelper.getType("child"), (String)"Get type child");
    }

    @Test
    public void testGetHighestPriorityMethod() {
        Assertions.assertEquals((Object)((Object)TestMethod.SAYHI_1), (Object)ApiMethodHelper.getHighestPriorityMethod(Arrays.asList(sayHis)), (String)"Get highest priority method");
    }

    @Test
    public void testInvokeMethod() {
        TestProxy proxy = new TestProxy();
        Assertions.assertEquals((Object)"Hello!", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI, Collections.emptyMap()), (String)"sayHi()");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", "Dave");
        Assertions.assertEquals((Object)"Hello Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI_1, properties), (String)"sayHi(name)");
        Assertions.assertEquals((Object)"Greetings Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETME, properties), (String)"greetMe(name)");
        properties.clear();
        properties.put("name1", "Dave");
        properties.put("name2", "Frank");
        Assertions.assertEquals((Object)"Greetings Dave, Frank", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETUS, properties), (String)"greetUs(name1, name2)");
        properties.clear();
        properties.put("names", new String[]{"Dave", "Frank"});
        Assertions.assertEquals((Object)"Greetings Dave, Frank", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETALL, properties), (String)"greetAll(names)");
        properties.clear();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("Dave", "Hello");
        nameMap.put("Frank", "Goodbye");
        properties.put("nameMap", nameMap);
        Map result = (Map)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETALL_2, properties);
        Assertions.assertNotNull((Object)result, (String)"greetAll(nameMap)");
        for (Map.Entry entry : result.entrySet()) {
            Assertions.assertTrue((boolean)((String)entry.getValue()).endsWith((String)entry.getKey()), (String)"greetAll(nameMap)");
        }
        proxy = new TestProxy(){

            @Override
            public String sayHi(String name) {
                return "Howdy " + name;
            }
        };
        properties.clear();
        properties.put("name", "Dave");
        Assertions.assertEquals((Object)"Howdy Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI_1, properties), (String)"Derived sayHi(name)");
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("say(.*)", "$1");
        apiMethodHelper = new ApiMethodHelper(TestMethod.class, aliases, List.of("names"));
    }

    static enum TestMethod implements ApiMethod
    {
        SAYHI(String.class, "sayHi", new ApiMethodArg[0]),
        SAYHI_1(String.class, "sayHi", ApiMethodArg.arg((String)"name", String.class)),
        GREETME(String.class, "greetMe", ApiMethodArg.arg((String)"name", String.class)),
        GREETUS(String.class, "greetUs", ApiMethodArg.arg((String)"name1", String.class), ApiMethodArg.arg((String)"name2", String.class)),
        GREETALL(String.class, "greetAll", ApiMethodArg.arg((String)"names", String[].class)),
        GREETALL_1(String.class, "greetAll", ApiMethodArg.arg((String)"nameList", List.class)),
        GREETALL_2(Map.class, "greetAll", ApiMethodArg.arg((String)"nameMap", Map.class)),
        GREETTIMES(String[].class, "greetTimes", ApiMethodArg.arg((String)"name", String.class), ApiMethodArg.arg((String)"times", Integer.TYPE)),
        GREETINNERCHILD(String[].class, "greetInnerChild", ApiMethodArg.arg((String)"child", TestProxy.InnerChild.class));

        private final ApiMethod apiMethod;

        private TestMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
            this.apiMethod = new ApiMethodImpl(TestProxy.class, resultType, name, args);
        }

        public String getName() {
            return this.apiMethod.getName();
        }

        public Class<?> getResultType() {
            return this.apiMethod.getResultType();
        }

        public List<String> getArgNames() {
            return this.apiMethod.getArgNames();
        }

        public List<Class<?>> getArgTypes() {
            return this.apiMethod.getArgTypes();
        }

        public Method getMethod() {
            return this.apiMethod.getMethod();
        }
    }
}

