/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.support.cache.SimpleSoftCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SimpleSoftCacheTest {
    private final SimpleSoftCache<Integer, Object> cache = new SimpleSoftCache(new ConcurrentHashMap());

    SimpleSoftCacheTest() {
    }

    @Test
    void testSoftCacheGetAndPut() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"bar");
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
        Assertions.assertNull((Object)this.cache.get((Object)3));
        Assertions.assertEquals((int)2, (int)this.cache.size());
        ((SoftReference)this.cache.getInnerCache().get(1)).clear();
        Assertions.assertEquals((int)2, (int)this.cache.size());
        Assertions.assertNull((Object)this.cache.get((Object)1));
        Assertions.assertEquals((int)1, (int)this.cache.size());
    }

    @Test
    void testSoftCacheContainsValue() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertTrue((boolean)this.cache.containsValue((Object)"foo"));
        Assertions.assertFalse((boolean)this.cache.containsValue((Object)"bar"));
        Assertions.assertFalse((boolean)this.cache.isEmpty());
        ((SoftReference)this.cache.getInnerCache().get(1)).clear();
        Assertions.assertFalse((boolean)this.cache.containsValue((Object)"foo"));
        Assertions.assertTrue((boolean)this.cache.isEmpty());
    }

    @Test
    void testSoftCacheForEach() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"bar");
        HashMap<Integer, Object> tmp = new HashMap<Integer, Object>((Map<Integer, Object>)this.cache);
        Assertions.assertEquals((Object)"foo", tmp.get(1));
        Assertions.assertEquals((Object)"bar", tmp.get(2));
        Assertions.assertNull(tmp.get(3));
        Assertions.assertEquals((int)2, (int)tmp.size());
        ((SoftReference)this.cache.getInnerCache().get(1)).clear();
        tmp = new HashMap<Integer, Object>((Map<Integer, Object>)this.cache);
        Assertions.assertNull(tmp.get(1));
        Assertions.assertEquals((Object)"bar", tmp.get(2));
        Assertions.assertNull(tmp.get(3));
        Assertions.assertEquals((int)1, (int)tmp.size());
    }

    @Test
    void testSoftCacheReplaceAll() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"bar");
        this.cache.replaceAll((k, v) -> String.valueOf(v) + "2");
        Assertions.assertEquals((Object)"foo2", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar2", (Object)this.cache.get((Object)2));
        Assertions.assertEquals((int)2, (int)this.cache.size());
    }

    @Test
    void testSoftCachePutIfAbsent() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertEquals((Object)"foo", (Object)this.cache.putIfAbsent((Object)1, (Object)"bar"));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.putIfAbsent((Object)2, (Object)"bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
    }

    @Test
    void testSoftCacheRemove() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertFalse((boolean)this.cache.remove((Object)2, (Object)"foo"));
        Assertions.assertFalse((boolean)this.cache.remove((Object)1, (Object)"bar"));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertFalse((boolean)this.cache.isEmpty());
        Assertions.assertTrue((boolean)this.cache.remove((Object)1, (Object)"foo"));
        Assertions.assertNull((Object)this.cache.get((Object)1));
        Assertions.assertTrue((boolean)this.cache.isEmpty());
    }

    @Test
    void testSoftCacheReplaceSpecific() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertFalse((boolean)this.cache.replace((Object)2, (Object)"foo", (Object)"bar"));
        Assertions.assertFalse((boolean)this.cache.replace((Object)1, (Object)"bar", (Object)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertTrue((boolean)this.cache.replace((Object)1, (Object)"foo", (Object)"bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)1));
    }

    @Test
    void testSoftCacheReplace() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertNull((Object)this.cache.replace((Object)2, (Object)"bar"));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.replace((Object)1, (Object)"bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)1));
    }

    @Test
    void testSoftCacheComputeIfAbsent() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertEquals((Object)"foo", (Object)this.cache.computeIfAbsent((Object)1, k -> "bar"));
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.computeIfAbsent((Object)2, k -> "bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
    }

    @Test
    void testSoftCacheComputeIfPresent() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertEquals((Object)"bar", (Object)this.cache.computeIfPresent((Object)1, (k, v) -> "bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.computeIfPresent((Object)1, (k, v) -> null));
        Assertions.assertNull((Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.computeIfPresent((Object)1, (k, v) -> "bar"));
    }

    @Test
    void testSoftCacheCompute() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertEquals((Object)"bar", (Object)this.cache.compute((Object)1, (k, v) -> "bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.compute((Object)1, (k, v) -> null));
        Assertions.assertNull((Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.compute((Object)1, (k, v) -> "bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.compute((Object)2, (k, v) -> null));
        Assertions.assertNull((Object)this.cache.get((Object)2));
    }

    @Test
    void testSoftCacheMerge() {
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertEquals((Object)"foo-2", (Object)this.cache.merge((Object)1, (Object)"2", (v1, v2) -> String.valueOf(v1) + "-" + String.valueOf(v2)));
        Assertions.assertEquals((Object)"foo-2", (Object)this.cache.get((Object)1));
        Assertions.assertNull((Object)this.cache.merge((Object)1, (Object)"2", (v1, v2) -> null));
        Assertions.assertNull((Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"2", (Object)this.cache.merge((Object)1, (Object)"2", (v1, v2) -> "bar"));
        Assertions.assertEquals((Object)"2", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"2", (Object)this.cache.merge((Object)2, (Object)"2", (v1, v2) -> null));
        Assertions.assertEquals((Object)"2", (Object)this.cache.get((Object)2));
    }

    @Test
    void testSimpleSoftCachePutOverride() {
        Object old = this.cache.put((Object)1, (Object)"foo");
        Assertions.assertNull((Object)old);
        old = this.cache.put((Object)2, (Object)"bar");
        Assertions.assertNull((Object)old);
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
        old = this.cache.put((Object)1, (Object)"changed");
        Assertions.assertEquals((Object)"foo", (Object)old);
        Assertions.assertEquals((Object)"changed", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((int)2, (int)this.cache.size());
    }

    @Test
    void testSimpleSoftCachePutAll() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "foo");
        map.put(2, "bar");
        this.cache.putAll(map);
        Assertions.assertEquals((Object)"foo", (Object)this.cache.get((Object)1));
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
        Assertions.assertNull((Object)this.cache.get((Object)3));
        Assertions.assertEquals((int)2, (int)this.cache.size());
    }

    @Test
    void testSimpleSoftCacheRemove() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.cache.get((Object)2));
        this.cache.remove((Object)2);
        Assertions.assertNull((Object)this.cache.get((Object)2));
    }

    @Test
    void testSimpleSoftCacheValues() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"bar");
        Collection col = this.cache.values();
        Assertions.assertEquals((int)2, (int)col.size());
        Iterator it = col.iterator();
        Assertions.assertEquals((Object)"foo", it.next());
        Assertions.assertEquals((Object)"bar", it.next());
    }

    @Test
    void testSimpleSoftCacheEmpty() {
        Assertions.assertTrue((boolean)this.cache.isEmpty());
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertFalse((boolean)this.cache.isEmpty());
        this.cache.put((Object)2, (Object)"bar");
        Assertions.assertFalse((boolean)this.cache.isEmpty());
        this.cache.remove((Object)2);
        Assertions.assertFalse((boolean)this.cache.isEmpty());
        this.cache.clear();
        Assertions.assertTrue((boolean)this.cache.isEmpty());
    }

    @Test
    void testSimpleSoftCacheContainsKey() {
        Assertions.assertFalse((boolean)this.cache.containsKey((Object)1));
        this.cache.put((Object)1, (Object)"foo");
        Assertions.assertTrue((boolean)this.cache.containsKey((Object)1));
        Assertions.assertFalse((boolean)this.cache.containsKey((Object)2));
        this.cache.put((Object)2, (Object)"foo");
        Assertions.assertTrue((boolean)this.cache.containsKey((Object)2));
    }

    @Test
    void testSimpleSoftCacheKeySet() {
        this.cache.put((Object)1, (Object)"foo");
        this.cache.put((Object)2, (Object)"foo");
        Set keys = this.cache.keySet();
        Assertions.assertEquals((int)2, (int)keys.size());
        Iterator it = keys.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)it.next()));
        Assertions.assertEquals((int)2, (int)((Integer)it.next()));
    }

    @Test
    void testSimpleSoftCacheNotRunOutOfMemory() {
        int maximumCacheSize = 1024;
        for (int i = 0; i < maximumCacheSize; ++i) {
            LargeObject data = new LargeObject();
            Integer key = i;
            this.cache.put((Object)key, (Object)data);
        }
        HashMap<Integer, Object> tmp = new HashMap<Integer, Object>((Map<Integer, Object>)this.cache);
        int size = tmp.size();
        Assertions.assertTrue((size < maximumCacheSize ? 1 : 0) != 0, (String)("Cache size should not be max, was: " + size));
    }

    public static class LargeObject {
        final byte[] data = new byte[0x6400000];
    }
}

