/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.support.cache.SimpleLRUCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.parallel.Isolated;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Isolated(value="Some of these tests creates a lot of threads")
@DisabledIfSystemProperty(named="ci.env.name", matches="apache.org", disabledReason="Apache CI nodes are too resource constrained for this test")
class SimpleLRUCacheTest {
    private final List<String> consumed = new ArrayList<String>();
    private final SimpleLRUCache<String, String> map = new SimpleLRUCache(16, 3, this.consumed::add);

    SimpleLRUCacheTest() {
    }

    @Test
    void forbiddenOperations() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.map.values().add("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.map.keySet().add("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.map.entrySet().add(Map.entry("x", "y")));
    }

    @Test
    void setValue() {
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.map.getQueueSize());
        Assertions.assertEquals((Object)"One", (Object)this.map.get((Object)"1"));
        ((Map.Entry)this.map.entrySet().iterator().next()).setValue("bar");
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.map.getQueueSize());
        Assertions.assertEquals((Object)"bar", (Object)this.map.get((Object)"1"));
        Assertions.assertThrows(NullPointerException.class, () -> ((Map.Entry)this.map.entrySet().iterator().next()).setValue(null));
    }

    @Test
    void queueSize() {
        Assertions.assertEquals((int)0, (int)this.map.getQueueSize());
        for (int i = 1; i <= 128; ++i) {
            this.map.put((Object)"1", (Object)Integer.toString(i));
            Assertions.assertEquals((int)1, (int)this.map.size());
            Assertions.assertEquals((int)i, (int)this.map.getQueueSize());
        }
        this.map.put((Object)"1", (Object)"A");
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.map.getQueueSize());
        this.map.put((Object)"1", (Object)"B");
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.map.getQueueSize());
        this.map.put((Object)"2", (Object)"A");
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((int)3, (int)this.map.getQueueSize());
        this.map.put((Object)"3", (Object)"A");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)4, (int)this.map.getQueueSize());
        this.map.put((Object)"4", (Object)"A");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)3, (int)this.map.getQueueSize());
    }

    @Test
    void size() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
    }

    @Test
    void isEmpty() {
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertFalse((boolean)this.map.isEmpty());
        this.map.remove((Object)"1");
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    void containsKey() {
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"1"));
        this.map.remove((Object)"1");
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.containsKey(null));
    }

    @Test
    void containsValue() {
        Assertions.assertFalse((boolean)this.map.containsValue((Object)"One"));
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)"One"));
        this.map.remove((Object)"1");
        Assertions.assertFalse((boolean)this.map.containsValue((Object)"One"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.containsValue(null));
    }

    @Test
    void remove() {
        Assertions.assertTrue((boolean)this.map.isEmpty());
        this.map.remove((Object)"1");
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertFalse((boolean)this.map.isEmpty());
        this.map.remove((Object)"1");
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.remove(null));
    }

    @Test
    void removeWithValue() {
        Assertions.assertTrue((boolean)this.map.isEmpty());
        this.map.remove((Object)"1", (Object)"One");
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertFalse((boolean)this.map.isEmpty());
        this.map.remove((Object)"1", (Object)"Two");
        Assertions.assertFalse((boolean)this.map.isEmpty());
        this.map.remove((Object)"2", (Object)"One");
        Assertions.assertFalse((boolean)this.map.isEmpty());
        this.map.remove((Object)"1", (Object)"One");
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.remove(null, (Object)"A"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.remove((Object)"A", null));
    }

    @Test
    void put() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"2", (Object)"Two"));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"3", (Object)"Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertNull((Object)this.map.put((Object)"4", (Object)"Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertEquals((Object)"Two", (Object)this.map.put((Object)"2", (Object)"Two v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertEquals((Object)"Two v2", (Object)this.map.get((Object)"2"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.put((Object)"A", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.put(null, (Object)"A"));
    }

    @Test
    void putAll() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("1", "One");
        data.put("2", "Two");
        data.put("3", "Three");
        this.map.putAll(data);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        data.clear();
        data.put("4", "Four");
        data.put("5", "Five");
        this.map.putAll(data);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertTrue((boolean)this.consumed.contains("Two"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.putAll(null));
    }

    @Test
    void clear() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.putAll(Map.of("1", "One", "2", "Two", "3", "Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void replaceAll() {
        this.map.replaceAll((k, v) -> v + " v2");
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.putAll(Map.of("1", "One", "2", "Two", "3", "Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.replaceAll((k, v) -> v + " v2");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((Object)"One v2", (Object)this.map.get((Object)"1"));
        Assertions.assertEquals((Object)"Two v2", (Object)this.map.get((Object)"2"));
        Assertions.assertEquals((Object)"Three v2", (Object)this.map.get((Object)"3"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replaceAll(null));
    }

    @Test
    void putIfAbsent() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertNull((Object)this.map.putIfAbsent((Object)"1", (Object)"One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertNull((Object)this.map.putIfAbsent((Object)"2", (Object)"Two"));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertNull((Object)this.map.putIfAbsent((Object)"3", (Object)"Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertNull((Object)this.map.putIfAbsent((Object)"4", (Object)"Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertEquals((Object)"Two", (Object)this.map.putIfAbsent((Object)"2", (Object)"Two v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertEquals((Object)"Two", (Object)this.map.get((Object)"2"));
        Assertions.assertNull((Object)this.map.putIfAbsent((Object)"5", (Object)"Five"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertTrue((boolean)this.consumed.contains("Two"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.putIfAbsent((Object)"A", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.putIfAbsent(null, (Object)"A"));
    }

    @Test
    void computeIfAbsent() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertEquals((Object)"One", (Object)this.map.computeIfAbsent((Object)"1", k -> "One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)"Two", (Object)this.map.computeIfAbsent((Object)"2", k -> "Two"));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((Object)"Three", (Object)this.map.computeIfAbsent((Object)"3", k -> "Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"Four", (Object)this.map.computeIfAbsent((Object)"4", k -> "Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertNull((Object)this.map.computeIfAbsent((Object)"1", k -> null));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertNull((Object)this.map.computeIfAbsent((Object)"5", k -> null));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertEquals((Object)"Two", (Object)this.map.computeIfAbsent((Object)"2", k -> "Two v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertEquals((Object)"Two", (Object)this.map.get((Object)"2"));
        Assertions.assertEquals((Object)"Five", (Object)this.map.computeIfAbsent((Object)"5", k -> "Five"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertTrue((boolean)this.consumed.contains("Two"));
        Assertions.assertEquals((Object)"Five", (Object)this.map.computeIfAbsent((Object)"5", k -> null));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)2, (int)this.consumed.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.computeIfAbsent(null, k -> null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.computeIfAbsent((Object)"A", null));
    }

    @Test
    void computeIfPresent() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.putIfAbsent((Object)"1", (Object)"One");
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.putIfAbsent((Object)"2", (Object)"Two");
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.putIfAbsent((Object)"3", (Object)"Three");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertNull((Object)this.map.computeIfPresent((Object)"4", (k, v) -> "Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"4"));
        Assertions.assertEquals((Object)"One v2", (Object)this.map.computeIfPresent((Object)"1", (k, v) -> "One v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertEquals((Object)"One v2", (Object)this.map.get((Object)"1"));
        Assertions.assertNull((Object)this.map.computeIfPresent((Object)"1", (k, v) -> null));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.computeIfPresent(null, (k, v) -> null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.computeIfPresent((Object)"A", null));
    }

    @Test
    void compute() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertEquals((Object)"One", (Object)this.map.compute((Object)"1", (k, v) -> "One"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)"Two", (Object)this.map.compute((Object)"2", (k, v) -> "Two"));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((Object)"Three", (Object)this.map.compute((Object)"3", (k, v) -> "Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"Four", (Object)this.map.compute((Object)"4", (k, v) -> "Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertEquals((Object)"Two v2", (Object)this.map.compute((Object)"2", (k, v) -> "Two v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertEquals((Object)"Two v2", (Object)this.map.get((Object)"2"));
        Assertions.assertNull((Object)this.map.compute((Object)"2", (k, v) -> null));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.compute(null, (k, v) -> null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.compute((Object)"A", null));
    }

    @Test
    void merge() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertEquals((Object)"One", (Object)this.map.merge((Object)"1", (Object)"One", String::concat));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)"Two", (Object)this.map.merge((Object)"2", (Object)"Two", String::concat));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((Object)"Three", (Object)this.map.merge((Object)"3", (Object)"Three", String::concat));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"Four", (Object)this.map.merge((Object)"4", (Object)"Four", String::concat));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("One"));
        Assertions.assertEquals((Object)"TwoV2", (Object)this.map.merge((Object)"2", (Object)"V2", String::concat));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertNull((Object)this.map.merge((Object)"2", (Object)"V2", (v1, v2) -> null));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.merge((Object)"A", (Object)"B", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.merge((Object)"A", null, (v1, v2) -> null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.merge(null, (Object)"A", (v1, v2) -> null));
    }

    @Test
    void replace() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertNull((Object)this.map.replace((Object)"1", (Object)"One"));
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put((Object)"1", (Object)"One");
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put((Object)"2", (Object)"Two");
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.put((Object)"3", (Object)"Three");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"One", (Object)this.map.replace((Object)"1", (Object)"One v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"Three", (Object)this.map.replace((Object)"3", (Object)"Three v2"));
        Assertions.assertEquals((Object)"Three v2", (Object)this.map.get((Object)"3"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replace((Object)"A", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replace(null, (Object)"A"));
    }

    @Test
    void replaceWithOldValue() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put((Object)"1", (Object)"One");
        this.map.put((Object)"2", (Object)"Two");
        this.map.put((Object)"3", (Object)"Three");
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertFalse((boolean)this.map.replace((Object)"1", (Object)"foo", (Object)"One"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertFalse((boolean)this.map.replace((Object)"1", (Object)"foo", (Object)"One v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"One", (Object)this.map.get((Object)"1"));
        Assertions.assertTrue((boolean)this.map.replace((Object)"1", (Object)"One", (Object)"One v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"One v2", (Object)this.map.get((Object)"1"));
        Assertions.assertFalse((boolean)this.map.replace((Object)"3", (Object)"foo", (Object)"Three v2"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertTrue((boolean)this.map.replace((Object)"3", (Object)"Three", (Object)"Three v2"));
        Assertions.assertEquals((Object)"Three v2", (Object)this.map.get((Object)"3"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replace((Object)"A", (Object)"B", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replace((Object)"A", null, (Object)"B"));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.replace(null, (Object)"A", (Object)"B"));
    }

    @Test
    void ignoreDuplicates() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        for (int i = 0; i < 100; ++i) {
            this.map.put((Object)"1", (Object)Integer.toString(i));
            Assertions.assertEquals((int)1, (int)this.map.size(), (String)String.format("The expected size is 1 but it fails after %d puts", i + 1));
        }
        Assertions.assertEquals((Object)"99", (Object)this.map.get((Object)"1"));
        Assertions.assertNull((Object)this.map.put((Object)"2", (Object)"Two"));
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertEquals((Object)"99", (Object)this.map.get((Object)"1"));
        Assertions.assertNull((Object)this.map.put((Object)"3", (Object)"Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)0, (int)this.consumed.size());
        Assertions.assertEquals((Object)"99", (Object)this.map.get((Object)"1"));
        Assertions.assertNull((Object)this.map.put((Object)"4", (Object)"Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"1"));
        Assertions.assertTrue((boolean)this.consumed.contains("99"));
    }

    @Test
    void ensureEvictionOrdering() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNull((Object)this.map.put((Object)"2", (Object)"Two"));
        Assertions.assertNotNull((Object)this.map.put((Object)"1", (Object)"One"));
        Assertions.assertNull((Object)this.map.put((Object)"3", (Object)"Three"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertNull((Object)this.map.put((Object)"4", (Object)"Four"));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((int)1, (int)this.consumed.size());
        Assertions.assertFalse((boolean)this.map.containsKey((Object)"2"));
        Assertions.assertTrue((boolean)this.consumed.contains("Two"));
    }

    @ParameterizedTest
    @ValueSource(ints={0, -1})
    void validateCacheSize(int maximumCacheSize) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SimpleLRUCache(16, maximumCacheSize, x -> {}));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 5, 10, 20, 50, 100, 1000})
    void concurrentPut(int maximumCacheSize) throws Exception {
        int threads = Runtime.getRuntime().availableProcessors();
        int totalKeysPerThread = 1000;
        AtomicInteger counter = new AtomicInteger();
        SimpleLRUCache cache = new SimpleLRUCache(16, maximumCacheSize, v -> counter.incrementAndGet());
        CountDownLatch latch = new CountDownLatch(threads);
        int i = 0;
        while (i < threads) {
            int threadId = i++;
            new Thread(() -> {
                try {
                    for (int j = 0; j < totalKeysPerThread; ++j) {
                        cache.put((Object)(threadId + "-" + j), (Object)Integer.toString(j));
                    }
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS), (String)("Should have completed within a reasonable timeframe. Latch at: " + latch.getCount()));
        Assertions.assertEquals((int)maximumCacheSize, (int)cache.size());
        Assertions.assertEquals((int)(totalKeysPerThread * threads - maximumCacheSize), (int)counter.get());
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 5, 10, 20, 50, 100, 500})
    void concurrentPutWithCollisions(int maximumCacheSize) throws Exception {
        int j;
        int threads = Runtime.getRuntime().availableProcessors();
        int totalKeys = 1000;
        AtomicInteger counter = new AtomicInteger();
        SimpleLRUCache cache = new SimpleLRUCache(16, maximumCacheSize, v -> counter.incrementAndGet());
        CountDownLatch latch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            new Thread(() -> {
                try {
                    for (int j = 0; j < totalKeys; ++j) {
                        cache.put((Object)Integer.toString(j), (Object)Integer.toString(j));
                    }
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS), (String)("Should have completed within a reasonable timeframe. Latch at: " + latch.getCount()));
        Assertions.assertEquals((int)maximumCacheSize, (int)cache.size());
        counter.set(0);
        for (j = 0; j < maximumCacheSize; ++j) {
            cache.put((Object)Integer.toString(j), (Object)"OK");
        }
        Assertions.assertEquals((int)maximumCacheSize, (int)counter.get());
        for (j = 0; j < maximumCacheSize; ++j) {
            Assertions.assertEquals((Object)"OK", (Object)cache.get((Object)Integer.toString(j)));
        }
    }
}

