/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.support.builder.RecordableInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordableInputStreamTest {
    private static final byte[] DATA = new byte[512];

    @Test
    public void testReadAndGetTextsBufferPurge() throws Exception {
        RecordableInputStream ris = new RecordableInputStream((InputStream)new ByteArrayInputStream(DATA), "utf-8");
        Assertions.assertEquals((int)0, (int)ris.size());
        byte[] buf = new byte[64];
        for (int i = 0; i < 8; ++i) {
            int n = ris.read(buf, 0, buf.length);
            Assertions.assertEquals((int)64, (int)n);
            Assertions.assertEquals((int)64, (int)ris.size());
            int offset = i * 64;
            String text = ris.getText(32);
            Assertions.assertEquals((Object)new String(DATA, offset, 32, StandardCharsets.UTF_8), (Object)text);
            Assertions.assertEquals((int)32, (int)ris.size());
            text = ris.getText(32);
            Assertions.assertEquals((Object)new String(DATA, offset + 32, 32, StandardCharsets.UTF_8), (Object)text);
            Assertions.assertEquals((int)0, (int)ris.size());
            ris.record();
        }
        ris.close();
    }

    @Test
    public void testReadAndGetTextsAutoStopRecord() throws Exception {
        RecordableInputStream ris = new RecordableInputStream((InputStream)new ByteArrayInputStream(DATA), "utf-8");
        Assertions.assertEquals((int)0, (int)ris.size());
        byte[] buf = new byte[64];
        int n = ris.read(buf, 0, buf.length);
        Assertions.assertEquals((int)64, (int)n);
        Assertions.assertEquals((int)64, (int)ris.size());
        String text = ris.getText(64);
        Assertions.assertEquals((Object)new String(DATA, 0, 64, StandardCharsets.UTF_8), (Object)text);
        Assertions.assertEquals((int)0, (int)ris.size());
        n = ris.read(buf, 0, buf.length);
        Assertions.assertEquals((int)64, (int)n);
        Assertions.assertEquals((int)0, (int)ris.size());
        ris.record();
        n = ris.read(buf, 0, buf.length);
        Assertions.assertEquals((int)64, (int)n);
        Assertions.assertEquals((int)64, (int)ris.size());
        text = ris.getText(64);
        Assertions.assertEquals((Object)new String(DATA, 128, 64, StandardCharsets.UTF_8), (Object)text);
        Assertions.assertEquals((int)0, (int)ris.size());
        ris.close();
    }

    static {
        int radix = 95;
        for (int i = 0; i < 512; ++i) {
            RecordableInputStreamTest.DATA[i] = (byte)(i % 95 + 32);
        }
    }
}

