/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TimerListener;
import org.apache.camel.support.TimerListenerManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerListenerManagerTest
extends ContextTestSupport {
    private final MyTask task = new MyTask();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testTimerListenerManager() throws Exception {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        TimerListenerManager manager = new TimerListenerManager();
        manager.setCamelContext((CamelContext)this.context);
        manager.addTimerListener((TimerListener)this.task);
        manager.start();
        Assertions.assertTrue((boolean)this.task.await(), (String)"Should be invoked");
        manager.stop();
        manager.removeTimerListener((TimerListener)this.task);
        executor.shutdown();
    }

    private static class MyTask
    implements TimerListener {
        private final CountDownLatch latch = new CountDownLatch(1);

        private MyTask() {
        }

        public void onTimer() {
            this.latch.countDown();
        }

        public boolean await() throws InterruptedException {
            return this.latch.await(5L, TimeUnit.SECONDS);
        }
    }
}

