/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.TestSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServiceSupportTest
extends TestSupport {
    @Test
    public void testServiceSupport() {
        MyService service = new MyService();
        service.start();
        Assertions.assertTrue((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
        Assertions.assertFalse((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        service.stop();
        Assertions.assertTrue((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        Assertions.assertFalse((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
    }

    @Test
    public void testServiceSupportIsRunAllowed() {
        MyService service = new MyService();
        Assertions.assertFalse((boolean)service.isRunAllowed());
        service.start();
        Assertions.assertTrue((boolean)service.isRunAllowed());
        service.suspend();
        Assertions.assertTrue((boolean)service.isRunAllowed());
        service.resume();
        Assertions.assertTrue((boolean)service.isRunAllowed());
        service.stop();
        Assertions.assertFalse((boolean)service.isRunAllowed());
        service.shutdown();
        Assertions.assertFalse((boolean)service.isRunAllowed());
    }

    @Test
    public void testServiceSupportShutdown() {
        MyShutdownService service = new MyShutdownService();
        service.start();
        Assertions.assertTrue((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
        Assertions.assertFalse((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        Assertions.assertFalse((boolean)service.isShutdown());
        service.shutdown();
        Assertions.assertTrue((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        Assertions.assertFalse((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
        Assertions.assertTrue((boolean)service.isShutdown());
    }

    @Test
    public void testExceptionOnStart() {
        ServiceSupportTestExOnStart service = new ServiceSupportTestExOnStart();
        Assertions.assertFalse((boolean)service.isStopped());
        try {
            service.start();
            Assertions.fail((String)"RuntimeException expected");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)service.isStopped());
            Assertions.assertFalse((boolean)service.isStopping());
            Assertions.assertFalse((boolean)service.isStarted());
            Assertions.assertFalse((boolean)service.isStarting());
        }
    }

    @Test
    public void testServiceBuild() {
        MyService service = new MyService();
        Assertions.assertTrue((boolean)service.isNew());
        service.build();
        Assertions.assertTrue((boolean)service.isBuild());
        Assertions.assertFalse((boolean)service.isInit());
        service.start();
        Assertions.assertTrue((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
        Assertions.assertFalse((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        service.stop();
        Assertions.assertTrue((boolean)service.isStopped());
        Assertions.assertFalse((boolean)service.isStopping());
        Assertions.assertFalse((boolean)service.isStarted());
        Assertions.assertFalse((boolean)service.isStarting());
    }

    private static class MyService
    extends ServiceSupport {
        private MyService() {
        }
    }

    private static class MyShutdownService
    extends ServiceSupport {
        private boolean shutdown;

        private MyShutdownService() {
        }

        protected void doShutdown() {
            this.shutdown = true;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }

    public static class ServiceSupportTestExOnStart
    extends ServiceSupport {
        public ServiceSupportTestExOnStart() {
            this.status = (byte)7;
        }

        protected void doStart() {
            throw new RuntimeException("This service throws an exception when starting");
        }
    }
}

