/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteWatcherReloadStrategyTest
extends ContextTestSupport {
    @Test
    public void testBasePathExact() throws Exception {
        RouteWatcherReloadStrategy strategy = new RouteWatcherReloadStrategy("./src/test/resources");
        strategy.setPattern("log4j2.properties");
        strategy.setCamelContext((CamelContext)this.context);
        strategy.doStart();
        Assertions.assertNotNull((Object)strategy.getFileFilter());
        File folder = new File("./src/test/resources");
        Assertions.assertTrue((boolean)folder.isDirectory());
        File[] fs = folder.listFiles(strategy.getFileFilter());
        Assertions.assertNotNull((Object)fs);
        Assertions.assertEquals((int)1, (int)fs.length);
        Assertions.assertEquals((Object)"log4j2.properties", (Object)fs[0].getName());
    }

    @Test
    public void testBasePathWildcardExtension() throws Exception {
        RouteWatcherReloadStrategy strategy = new RouteWatcherReloadStrategy("./src/test/resources");
        strategy.setPattern("*.properties");
        strategy.setCamelContext((CamelContext)this.context);
        strategy.doStart();
        Assertions.assertNotNull((Object)strategy.getFileFilter());
        File folder = new File("./src/test/resources");
        Assertions.assertTrue((boolean)folder.isDirectory());
        File[] fs = folder.listFiles(strategy.getFileFilter());
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((fs.length >= 5 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Arrays.stream(fs).anyMatch(f -> f.getName().equals("log4j2.properties")));
    }

    @Test
    public void testBasePathFullWildcard() throws Exception {
        RouteWatcherReloadStrategy strategy = new RouteWatcherReloadStrategy("./src/test/resources");
        strategy.setPattern("*");
        strategy.setCamelContext((CamelContext)this.context);
        strategy.doStart();
        Assertions.assertNotNull((Object)strategy.getFileFilter());
        File folder = new File("./src/test/resources");
        Assertions.assertTrue((boolean)folder.isDirectory());
        File[] fs = folder.listFiles(strategy.getFileFilter());
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((fs.length >= 9 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Arrays.stream(fs).anyMatch(f -> f.getName().equals("log4j2.properties")));
    }

    @Test
    public void testNullPattern() throws Exception {
        RouteWatcherReloadStrategy strategy = new RouteWatcherReloadStrategy("./src/test/resources/org/apache/camel/model");
        strategy.setPattern(null);
        strategy.setCamelContext((CamelContext)this.context);
        strategy.doStart();
        Assertions.assertNotNull((Object)strategy.getFileFilter());
        File folder = new File("./src/test/resources/org/apache/camel/model");
        Assertions.assertTrue((boolean)folder.isDirectory());
        File[] fs = folder.listFiles(strategy.getFileFilter());
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((fs.length >= 40 ? 1 : 0) != 0, (String)String.valueOf(fs.length));
        Assertions.assertEquals((Object)"*.yaml,*.xml", (Object)strategy.getPattern());
    }
}

