/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.Animal;
import org.apache.camel.support.Company;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work = new Company();
        work.setId(456);
        work.setName("Acme");
        context.getRegistry().bind("myWork", (Object)work);
        Properties placeholders = new Properties();
        placeholders.put("companyName", "Acme");
        placeholders.put("committer", "rider");
        context.getPropertiesComponent().setInitialProperties(placeholders);
        return context;
    }

    @Test
    public void testProperties() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.work.id", "123");
        prop.put("bar.work.name", "{{companyName}}");
        PropertyBindingSupport.bindProperties((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testProperty() {
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Properties prop = new Properties();
        prop.setProperty("customerName", "James");
        prop.setProperty("customerAge", "33");
        prop.setProperty("workKey", "customerWork");
        prop.setProperty("customerWork", "Acme");
        pc.setInitialProperties(prop);
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"#property:customerName");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"#property:customerAge");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.rider", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work.id", (Object)"456");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work.name", (Object)"#property:{{workKey}}");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"#property:unknown");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"name", (Object)e.getPropertyName());
            Assertions.assertEquals((Object)"#property:unknown", (Object)e.getValue());
            Assertions.assertEquals((Object)"Property with key unknown not found by properties component", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testWithFluentBuilder() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.work.name", "{{companyName}}");
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withTarget((Object)foo).withProperty("name", (Object)"James").withProperty("bar.work.id", (Object)"123").withProperties(prop).bind();
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testPropertiesNoReflection() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.AGE", "33");
        PropertyBindingSupport.build().withReflection(false).bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertNull((Object)foo.getName());
        Assertions.assertEquals((int)0, (int)foo.getBar().getAge());
        Assertions.assertEquals((int)2, (int)prop.size());
    }

    @Test
    public void testPropertiesIgnoreCase() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.AGE", "33");
        prop.put("BAR.{{committer}}", "true");
        prop.put("bar.gOLd-Customer", "true");
        prop.put("bAr.work.ID", "123");
        prop.put("bar.WORk.naME", "{{companyName}}");
        PropertyBindingSupport.build().withIgnoreCase(true).bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testPropertiesDash() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.work.id", "123");
        prop.put("bar.work.name", "{{companyName}}");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testBindPropertiesWithOptionPrefix() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("my.prefix.name", "James");
        prop.put("my.prefix.bar.age", "33");
        prop.put("my.prefix.bar.{{committer}}", "true");
        prop.put("my.prefix.bar.gold-customer", "true");
        prop.put("my.prefix.bar.work.id", "123");
        prop.put("my.prefix.bar.work.name", "{{companyName}}");
        prop.put("my.other.prefix.something", "test");
        PropertyBindingSupport.build().withOptionPrefix("my.prefix.").bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.containsKey("my.other.prefix.something"));
        Assertions.assertEquals((int)1, (int)prop.size());
    }

    @Test
    public void testBindPropertiesWithOptionPrefixIgnoreCase() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("my.prefix.name", "James");
        prop.put("my.PREFIX.bar.AGE", "33");
        prop.put("my.prefix.bar.{{committer}}", "true");
        prop.put("My.prefix.bar.Gold-custoMER", "true");
        prop.put("mY.prefix.bar.work.ID", "123");
        prop.put("my.prEFIx.bar.Work.Name", "{{companyName}}");
        prop.put("my.other.prefix.something", "test");
        PropertyBindingSupport.build().withOptionPrefix("my.prefix.").withIgnoreCase(true).bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.containsKey("my.other.prefix.something"));
        Assertions.assertEquals((int)1, (int)prop.size());
    }

    @Test
    public void testNested() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.{{committer}}", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work.id", (Object)"123");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work.name", (Object)"{{companyName}}");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testNestedReference() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.rider", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#bean:myWork");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testNestedReferenceId() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.rider", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#bean:myWork");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testNestedType() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.{{committer}}", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#type:org.apache.camel.support.Company");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testNestedClass() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.{{committer}}", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#class:org.apache.camel.support.Company");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)0, (int)foo.getBar().getWork().getId());
        Assertions.assertNull((Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testAutowired() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.{{committer}}", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#autowired");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
    }

    @Test
    public void testMandatory() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().withMandatory(true).bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        boolean bound = PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.myAge", (Object)"33");
        Assertions.assertFalse((boolean)bound);
        try {
            PropertyBindingSupport.build().withMandatory(true).bind((CamelContext)this.context, (Object)foo, "bar.myAge", (Object)"33");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"myAge", (Object)e.getPropertyName());
            Assertions.assertSame((Object)foo.getBar(), (Object)e.getTarget());
        }
    }

    @Test
    public void testDoesNotExistClass() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#class:org.apache.camel.support.DoesNotExist");
            Assertions.fail((String)"Should throw exception");
        }
        catch (PropertyBindingException e) {
            PropertyBindingSupportTest.assertIsInstanceOf(ClassNotFoundException.class, e.getCause());
        }
    }

    @Test
    public void testNullInjectorClass() {
        Foo foo = new Foo();
        this.context.setInjector(new Injector(){

            public <T> T newInstance(Class<T> type) {
                return null;
            }

            public <T> T newInstance(Class<T> type, String factoryMethod) {
                return null;
            }

            public <T> T newInstance(Class<T> type, Class<?> factoryClass, String factoryMethod) {
                return null;
            }

            public <T> T newInstance(Class<T> type, boolean postProcessBean) {
                return null;
            }

            public boolean supportsAutoWiring() {
                return false;
            }
        });
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.work", (Object)"#class:org.apache.camel.support.Company");
            Assertions.fail((String)"Should throw exception");
        }
        catch (PropertyBindingException e) {
            PropertyBindingSupportTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        }
    }

    @Test
    public void testNestedClassConstructorParameterOneParameter() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.Animal('Tony Tiger')");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal.dangerous", (Object)"true");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Tony Tiger", (Object)foo.getAnimal().getName());
        Assertions.assertTrue((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassConstructorParameterPlaceholder() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.Animal('{{companyName}}', false)");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getAnimal().getName());
        Assertions.assertFalse((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassConstructorParameterTwoParameter() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.Animal('Donald Duck', false)");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Donald Duck", (Object)foo.getAnimal().getName());
        Assertions.assertFalse((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassConstructorParameterMandatoryBean() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.Animal('#bean:myName', false)");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            NoSuchBeanException nsb = PropertyBindingSupportTest.assertIsInstanceOf(NoSuchBeanException.class, e.getCause());
            Assertions.assertEquals((Object)"myName", (Object)nsb.getName());
        }
        this.context.getRegistry().bind("myName", (Object)"Acme");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.Animal('#bean:myName', false)");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getAnimal().getName());
        Assertions.assertFalse((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassFactoryParameterOneParameter() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.AnimalFactory#createAnimal('Tiger')");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Tiger", (Object)foo.getAnimal().getName());
        Assertions.assertTrue((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassFactoryParameterTwoParameter() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.AnimalFactory#createAnimal('Donald Duck', false)");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Donald Duck", (Object)foo.getAnimal().getName());
        Assertions.assertFalse((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testNestedClassFactoryParameterPlaceholder() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "animal", (Object)"#class:org.apache.camel.support.AnimalFactory#createAnimal('{{companyName}}', false)");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getAnimal().getName());
        Assertions.assertFalse((boolean)foo.getAnimal().isDangerous());
    }

    @Test
    public void testPropertiesOptionalKey() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("?bar.AGE", "33");
        prop.put("BAR.{{committer}}", "true");
        prop.put("bar.gOLd-Customer", "true");
        prop.put("?bar.silver-Customer", "true");
        prop.put("?bAr.work.ID", "123");
        prop.put("?bar.WORk.naME", "{{companyName}}");
        prop.put("?bar.work.addresss", "Some street");
        prop.put("?bar.work.addresss.zip", "1234");
        PropertyBindingSupport.build().withIgnoreCase(true).bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertFalse((boolean)prop.isEmpty(), (String)"Should NOT bind all properties");
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertTrue((boolean)prop.containsKey("?bar.silver-Customer"));
        Assertions.assertTrue((boolean)prop.containsKey("?bar.work.addresss"));
        Assertions.assertTrue((boolean)prop.containsKey("?bar.work.addresss.zip"));
    }

    @Test
    public void testPropertiesOptionalKeyMandatory() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.AGE", "33");
        prop.put("BAR.{{committer}}", "true");
        prop.put("bar.gOLd-Customer", "true");
        prop.put("?bar.silver-Customer", "true");
        prop.put("?bAr.work.ID", "123");
        prop.put("?bar.WORk.naME", "{{companyName}}");
        prop.put("?bar.work.addresss", "Some street");
        prop.put("?bar.work.addresss.zip", "1234");
        PropertyBindingSupport.build().withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertFalse((boolean)prop.isEmpty(), (String)"Should NOT bind all properties");
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertTrue((boolean)prop.containsKey("?bar.silver-Customer"));
        Assertions.assertTrue((boolean)prop.containsKey("?bar.work.addresss"));
        Assertions.assertTrue((boolean)prop.containsKey("?bar.work.addresss.zip"));
        prop.put("?bar.unknown", "123");
        PropertyBindingSupport.build().withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)foo, prop);
        prop.remove("?bar.unknown");
        prop.put("bar.unknown", "123");
        try {
            PropertyBindingSupport.build().withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)foo, prop);
            Assertions.fail((String)"Should fail");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"unknown", (Object)e.getPropertyName());
        }
    }

    @Test
    public void testConvert() {
        Foo foo = new Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "#valueAs(Integer):33");
        prop.put("bar.rider", "#valueAs(boolean):true");
        prop.put("bar.gold-customer", "#valueAs(boolean):true");
        prop.put("bar.work.id", "#valueAs(int):123");
        prop.put("bar.work.name", "{{companyName}}");
        PropertyBindingSupport.bindProperties((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    public static class Foo {
        private String name;
        private Bar bar = new Bar();
        private Animal animal;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }

        public Animal getAnimal() {
            return this.animal;
        }

        public void setAnimal(Animal animal) {
            this.animal = animal;
        }
    }

    public static class Bar {
        private int age;
        private boolean rider;
        private Company work;
        private boolean goldCustomer;

        public int getAge() {
            return this.age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public Company getWork() {
            return this.work;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public Bar withAge(int age) {
            this.age = age;
            return this;
        }

        public Bar withRider(boolean rider) {
            this.rider = rider;
            return this;
        }

        public Bar work(Company work) {
            this.work = work;
            return this;
        }

        public Bar goldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
            return this;
        }
    }
}

