/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportPropertiesTest
extends ContextTestSupport {
    @Test
    public void testProperties() {
        Bar bar = new Bar();
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withReflection(true).withTarget((Object)bar).withProperty("works[acme]", (Object)"company1").withProperty("works[burger]", (Object)"company2").bind();
        Assertions.assertEquals((Object)"company1", (Object)bar.getWorks().getProperty("acme"));
        Assertions.assertEquals((Object)"company2", (Object)bar.getWorks().getProperty("burger"));
    }

    @Test
    public void testPropertiesWithConfigurer() {
        Bar bar = new Bar();
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withReflection(false).withConfigurer((PropertyConfigurer)new BarConfigurer()).withTarget((Object)bar).withProperty("works[acme]", (Object)"company1").withProperty("works[burger]", (Object)"company2").bind();
        Assertions.assertEquals((Object)"company1", (Object)bar.getWorks().getProperty("acme"));
        Assertions.assertEquals((Object)"company2", (Object)bar.getWorks().getProperty("burger"));
    }

    @Test
    public void testPropertiesMap() {
        BarWithMap bar = new BarWithMap();
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withReflection(true).withTarget((Object)bar).withProperty("works[acme].name", (Object)"company1").withProperty("works[burger].name", (Object)"company2").bind();
        Assertions.assertEquals((Object)"company1", (Object)bar.getWorks().get("acme").getProperty("name"));
        Assertions.assertEquals((Object)"company2", (Object)bar.getWorks().get("burger").getProperty("name"));
    }

    @Test
    public void testPropertiesMapWithConfigurer() {
        BarWithMap bar = new BarWithMap();
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withReflection(false).withConfigurer((PropertyConfigurer)new BarWithMapConfigurer()).withTarget((Object)bar).withProperty("works[acme].name", (Object)"company1").withProperty("works[burger].name", (Object)"company2").bind();
        Assertions.assertEquals((Object)"company1", (Object)bar.getWorks().get("acme").getProperty("name"));
        Assertions.assertEquals((Object)"company2", (Object)bar.getWorks().get("burger").getProperty("name"));
    }

    public static class Bar {
        private Properties works;

        public Properties getWorks() {
            return this.works;
        }

        public void setWorks(Properties works) {
            this.works = works;
        }
    }

    private static class BarConfigurer
    implements PropertyConfigurer,
    PropertyConfigurerGetter {
        private BarConfigurer() {
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof Bar) {
                Bar bar = (Bar)target;
                if ("works".equals(name)) {
                    bar.setWorks((Properties)value);
                    return true;
                }
            }
            return false;
        }

        public Class<?> getOptionType(String name, boolean ignoreCase) {
            if ("works".equals(name)) {
                return Properties.class;
            }
            return null;
        }

        public Object getOptionValue(Object target, String name, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof Bar) {
                Bar bar = (Bar)target;
                if ("works".equals(name)) {
                    return bar.getWorks();
                }
            }
            return null;
        }
    }

    public static class BarWithMap {
        private Map<String, Properties> works;

        public Map<String, Properties> getWorks() {
            return this.works;
        }

        public void setWorks(Map<String, Properties> works) {
            this.works = works;
        }
    }

    private static class BarWithMapConfigurer
    implements PropertyConfigurer,
    PropertyConfigurerGetter {
        private BarWithMapConfigurer() {
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof BarWithMap) {
                BarWithMap bar = (BarWithMap)target;
                if ("works".equals(name)) {
                    bar.setWorks((Map)value);
                    return true;
                }
            }
            return false;
        }

        public Class<?> getOptionType(String name, boolean ignoreCase) {
            if ("works".equals(name)) {
                return Map.class;
            }
            return null;
        }

        public Object getOptionValue(Object target, String name, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof BarWithMap) {
                BarWithMap bar = (BarWithMap)target;
                if ("works".equals(name)) {
                    return bar.getWorks();
                }
            }
            return null;
        }

        public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
            if ("works".equals(name)) {
                return Properties.class;
            }
            return null;
        }
    }
}

