/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.support.Company;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportMapTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work1 = new Company();
        work1.setId(123);
        work1.setName("Acme");
        context.getRegistry().bind("company1", (Object)work1);
        Company work2 = new Company();
        work2.setId(456);
        work2.setName("Acme 2");
        context.getRegistry().bind("company2", (Object)work2);
        Properties placeholders = new Properties();
        placeholders.put("companyName", "Acme");
        placeholders.put("committer", "rider");
        context.getPropertiesComponent().setInitialProperties(placeholders);
        return context;
    }

    @Test
    public void testPropertiesMap() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.works[acme]", "#bean:company1");
        prop.put("bar.works[burger]", "#bean:company2");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)2, (int)foo.getBar().getWorks().size());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWorks().get("acme").getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWorks().get("acme").getName());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWorks().get("burger").getId());
        Assertions.assertEquals((Object)"Acme 2", (Object)foo.getBar().getWorks().get("burger").getName());
    }

    @Test
    public void testPropertiesMapNested() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.works[acme]", "#bean:company1");
        prop.put("bar.works[acme].id", "666");
        prop.put("bar.works[burger]", "#bean:company2");
        prop.put("bar.works[burger].name", "I changed this");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)2, (int)foo.getBar().getWorks().size());
        Assertions.assertEquals((int)666, (int)foo.getBar().getWorks().get("acme").getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWorks().get("acme").getName());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWorks().get("burger").getId());
        Assertions.assertEquals((Object)"I changed this", (Object)foo.getBar().getWorks().get("burger").getName());
    }

    @Test
    public void testPropertiesMapFirst() {
        Bar bar = new Bar();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("works[acme]", "#bean:company1");
        prop.put("works[acme].id", "666");
        prop.put("works[burger]", "#bean:company2");
        prop.put("works[burger].name", "I changed this");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)2, (int)bar.getWorks().size());
        Assertions.assertEquals((int)666, (int)bar.getWorks().get("acme").getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWorks().get("acme").getName());
        Assertions.assertEquals((int)456, (int)bar.getWorks().get("burger").getId());
        Assertions.assertEquals((Object)"I changed this", (Object)bar.getWorks().get("burger").getName());
    }

    @Test
    public void testPropertiesNotMap() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.gold-customer[foo]", "true");
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"gold-customer[foo]", (Object)e.getPropertyName());
            IllegalArgumentException iae = PropertyBindingSupportMapTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertTrue((boolean)iae.getMessage().startsWith("Cannot set property: gold-customer[foo] as either a Map/List/array because target bean is not a Map, List or array type"));
        }
    }

    public static class Foo {
        private String name;
        private Bar bar = new Bar();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }
    }

    public static class Bar {
        private int age;
        private boolean rider;
        private Map<String, Company> works;
        private boolean goldCustomer;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public void setRider(boolean rider) {
            this.rider = rider;
        }

        public Map<String, Company> getWorks() {
            return this.works;
        }

        public void setWorks(Map<String, Company> works) {
            this.works = works;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public void setGoldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
        }
    }
}

