/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportMapKeyWithDotTest
extends ContextTestSupport {
    @Test
    public void testPropertiesMap() {
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("id", "123");
        prop.put("database.name", "MySQL");
        prop.put("database.timezone", "CET");
        prop.put("database.client.id", "123");
        prop.put("database.client.type", "Basic");
        HashMap map = new HashMap();
        PropertyBindingSupport.build().bind((CamelContext)this.context, map, prop);
        Assertions.assertEquals((Object)"123", map.get("id"));
        Assertions.assertEquals((Object)"MySQL", map.get("database.name"));
        Assertions.assertEquals((Object)"CET", map.get("database.timezone"));
        Assertions.assertEquals((Object)"123", map.get("database.client.id"));
        Assertions.assertEquals((Object)"Basic", map.get("database.client.type"));
    }

    @Test
    public void testPropertiesConfigMap() {
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("id", "123");
        prop.put("config.database.name", "MySQL");
        prop.put("config.database.timezone", "CET");
        prop.put("config.database.client.id", "123");
        prop.put("config.database.client.type", "Basic");
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"123", (Object)foo.getId());
        Assertions.assertEquals((Object)"MySQL", (Object)foo.getConfig().get("database.name"));
        Assertions.assertEquals((Object)"CET", (Object)foo.getConfig().get("database.timezone"));
        Assertions.assertEquals((Object)"123", (Object)foo.getConfig().get("database.client.id"));
        Assertions.assertEquals((Object)"Basic", (Object)foo.getConfig().get("database.client.type"));
    }

    public static class Foo {
        private String id;
        private Map<String, String> config;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, String> config) {
            this.config = config;
        }
    }
}

