/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportMapDotKeyTest
extends ContextTestSupport {
    @Test
    public void testPropertiesMapDotKey() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("data[age]", "33");
        prop.put("data[zip.code]", "90210");
        prop.put("data[ISO.CODE]", "USA");
        prop.put("data[with-dash]", "123");
        prop.put("data[with_underscore]", "456");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((Object)"33", (Object)foo.getData().get("age"));
        Assertions.assertEquals((Object)"90210", (Object)foo.getData().get("zip.code"));
        Assertions.assertEquals((Object)"USA", (Object)foo.getData().get("ISO.CODE"));
        Assertions.assertEquals((Object)"123", (Object)foo.getData().get("with-dash"));
        Assertions.assertEquals((Object)"456", (Object)foo.getData().get("with_underscore"));
    }

    public static class Foo {
        private String name;
        private Map<String, String> data = new HashMap<String, String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }
    }
}

