/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.Animal;
import org.apache.camel.support.Company;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportFlattenTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work = new Company();
        work.setId(456);
        work.setName("Acme");
        context.getRegistry().bind("myWork", (Object)work);
        Properties placeholders = new Properties();
        placeholders.put("companyName", "Acme");
        placeholders.put("committer", "rider");
        context.getPropertiesComponent().setInitialProperties(placeholders);
        return context;
    }

    @Test
    public void testProperties() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"name", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"age", (Object)"33", (Object[])new Object[]{"{{committer}}", "true", "gold-customer", "true", "work", CollectionHelper.mapOf((Object)"id", (Object)"123", (Object[])new Object[]{"name", "{{companyName}}"})})});
        PropertyBindingSupport.bindWithFlattenProperties((CamelContext)this.context, (Object)foo, (Map)map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testProperty() {
        PropertiesComponent pc = this.context.getPropertiesComponent();
        Properties prop = new Properties();
        prop.setProperty("customerName", "James");
        prop.setProperty("customerAge", "33");
        prop.setProperty("workKey", "customerWork");
        prop.setProperty("customerWork", "Acme");
        pc.setInitialProperties(prop);
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"name", (Object)"#property:customerName", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"age", (Object)"#property:customerAge", (Object[])new Object[]{"rider", "true", "gold-customer", "true", "work", CollectionHelper.mapOf((Object)"id", (Object)"456", (Object[])new Object[]{"name", "#property:{{workKey}}"})})});
        PropertyBindingSupport.bindWithFlattenProperties((CamelContext)this.context, (Object)foo, (Map)map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"#property:unknown");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"name", (Object)e.getPropertyName());
            Assertions.assertEquals((Object)"#property:unknown", (Object)e.getValue());
            Assertions.assertEquals((Object)"Property with key unknown not found by properties component", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testWithFluentBuilder() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"bar", (Object)CollectionHelper.mapOf((Object)"age", (Object)"33", (Object[])new Object[]{"rider", "true", "gold-customer", "true", "work", CollectionHelper.mapOf((Object)"name", (Object)"{{companyName}}", (Object[])new Object[0])}), (Object[])new Object[0]);
        PropertyBindingSupport.build().withCamelContext((CamelContext)this.context).withTarget((Object)foo).withProperty("name", (Object)"James").withProperty("bar.work.id", (Object)"123").withFlattenProperties(true).withProperties(map).bind();
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testPropertiesNoReflection() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"name", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"AGE", (Object)"33", (Object[])new Object[0])});
        PropertyBindingSupport.build().withFlattenProperties(true).withReflection(false).bind((CamelContext)this.context, (Object)foo, map);
        Assertions.assertNull((Object)foo.getName());
        Assertions.assertEquals((int)0, (int)foo.getBar().getAge());
        Assertions.assertEquals((int)2, (int)map.size());
    }

    @Test
    public void testPropertiesIgnoreCase() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"nAMe", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"age", (Object)"33", (Object[])new Object[]{"{{committer}}", "true", "gOLd-Customer", "true", "WoRk", CollectionHelper.mapOf((Object)"ID", (Object)"123", (Object[])new Object[]{"naME", "{{companyName}}"})})});
        PropertyBindingSupport.build().withFlattenProperties(true).withIgnoreCase(true).bind((CamelContext)this.context, (Object)foo, map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testPropertiesDash() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"name", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"age", (Object)"33", (Object[])new Object[]{"{{committer}}", "true", "gold-customer", "true", "work", CollectionHelper.mapOf((Object)"id", (Object)"123", (Object[])new Object[]{"name", "{{companyName}}"})})});
        PropertyBindingSupport.build().withFlattenProperties(true).bind((CamelContext)this.context, (Object)foo, map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testBindPropertiesWithOptionPrefix() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"my", (Object)CollectionHelper.mapOf((Object)"prefix", (Object)CollectionHelper.mapOf((Object)"name", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"age", (Object)"33", (Object[])new Object[]{"{{committer}}", "true", "gold-customer", "true", "work", CollectionHelper.mapOf((Object)"id", (Object)"123", (Object[])new Object[]{"name", "{{companyName}}"})})}), (Object[])new Object[0]), (Object[])new Object[]{"other", CollectionHelper.mapOf((Object)"something", (Object)"test", (Object[])new Object[0])});
        PropertyBindingSupport.build().withFlattenProperties(true).withOptionPrefix("my.prefix.").bind((CamelContext)this.context, (Object)foo, map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Map other = (Map)map.get("other");
        Assertions.assertEquals((int)1, (int)other.size());
        Assertions.assertEquals((Object)"test", other.get("something"));
    }

    @Test
    public void testPropertiesOptionalKey() {
        Foo foo = new Foo();
        Map map = CollectionHelper.mapOf((Object)"name", (Object)"James", (Object[])new Object[]{"bar", CollectionHelper.mapOf((Object)"AGE", (Object)"33", (Object[])new Object[]{"{{committer}}", "true", "gOLd-customer", "true", "?silver-Customer", "true", "WoRk", CollectionHelper.mapOf((Object)"?ID", (Object)"123", (Object[])new Object[]{"?naME", "{{companyName}}", "adress", CollectionHelper.mapOf((Object)"?Street", (Object)"Some street", (Object[])new Object[]{"?zip", "1234"})})})});
        PropertyBindingSupport.build().withFlattenProperties(true).withIgnoreCase(true).bind((CamelContext)this.context, (Object)foo, map);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertFalse((boolean)map.isEmpty(), (String)"Should NOT bind all properties");
        Map bar = (Map)map.get("bar");
        Map work = (Map)bar.get("WoRk");
        Map adr = (Map)work.get("adress");
        Assertions.assertTrue((boolean)bar.containsKey("?silver-Customer"));
        Assertions.assertTrue((boolean)adr.containsKey("?Street"));
        Assertions.assertTrue((boolean)adr.containsKey("?zip"));
    }

    public static class Foo {
        private String name;
        private Bar bar = new Bar();
        private Animal animal;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }

        public Animal getAnimal() {
            return this.animal;
        }

        public void setAnimal(Animal animal) {
            this.animal = animal;
        }
    }

    public static class Bar {
        private int age;
        private boolean rider;
        private Company work;
        private boolean goldCustomer;

        public int getAge() {
            return this.age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public Company getWork() {
            return this.work;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public Bar withAge(int age) {
            this.age = age;
            return this;
        }

        public Bar withRider(boolean rider) {
            this.rider = rider;
            return this;
        }

        public Bar work(Company work) {
            this.work = work;
            return this;
        }

        public Bar goldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
            return this;
        }
    }
}

