/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.Company;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.PropertyBindingSupportTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportConfigurerTest
extends ContextTestSupport {
    private final MyConfigurer myConfigurer = new MyConfigurer();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work = new Company();
        work.setId(456);
        work.setName("Acme");
        context.getRegistry().bind("myWork", (Object)work);
        Properties placeholders = new Properties();
        placeholders.put("companyName", "Acme");
        placeholders.put("committer", "rider");
        context.getPropertiesComponent().setInitialProperties(placeholders);
        return context;
    }

    @Test
    public void testProperties() {
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.context);
        bi.setExtendedStatistics(true);
        bi.setLoggingLevel(LoggingLevel.WARN);
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("age", "33");
        prop.put("{{committer}}", "true");
        prop.put("gold-customer", "true");
        prop.put("products[foo]", "bar");
        prop.put("products[bar]", "baz");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)7, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertNull((Object)bar.getWork());
        Assertions.assertNotNull(bar.getProducts());
        Assertions.assertEquals((int)2, (int)bar.getProducts().size());
        Assertions.assertEquals((Object)"bar", (Object)bar.getProducts().get("foo"));
        Assertions.assertEquals((Object)"baz", (Object)bar.getProducts().get("bar"));
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
        Assertions.assertEquals((long)0L, (long)bi.getInvokedCounter());
    }

    @Test
    public void testFreshMapInstance() {
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.context);
        bi.setExtendedStatistics(true);
        bi.setLoggingLevel(LoggingLevel.WARN);
        Bar bar = new Bar(){

            @Override
            public void setProducts(Map<String, String> products) {
                super.setProducts(new HashMap<String, String>(products));
            }
        };
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("products[foo]", "bar");
        prop.put("products[bar]", "baz");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)4, (int)this.myConfigurer.getCounter());
        Assertions.assertNotNull(bar.getProducts());
        Assertions.assertEquals((int)2, (int)bar.getProducts().size());
        Assertions.assertEquals((Object)"bar", (Object)bar.getProducts().get("foo"));
        Assertions.assertEquals((Object)"baz", (Object)bar.getProducts().get("bar"));
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
        Assertions.assertEquals((long)0L, (long)bi.getInvokedCounter());
    }

    @Test
    public void testPropertiesNested() {
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.context);
        bi.setExtendedStatistics(true);
        bi.setLoggingLevel(LoggingLevel.WARN);
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("age", "33");
        prop.put("{{committer}}", "true");
        prop.put("gold-customer", "true");
        prop.put("work.id", "123");
        prop.put("work.name", "{{companyName}}");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)6, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertEquals((int)123, (int)bar.getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
        Assertions.assertTrue((bi.getInvokedCounter() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testAutowired() {
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("age", "33");
        prop.put("{{committer}}", "true");
        prop.put("gold-customer", "true");
        prop.put("work", "#autowired");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)4, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertEquals((int)456, (int)bar.getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    @Test
    public void testPropertiesOptionalKey() {
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("?AGE", "33");
        prop.put("{{committer}}", "true");
        prop.put("gOLd-Customer", "true");
        prop.put("?silver-Customer", "true");
        prop.put("?work.ID", "123");
        prop.put("?WORk.naME", "{{companyName}}");
        prop.put("?work.addresss", "Some street");
        prop.put("?work.addresss.zip", "1234");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)7, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertEquals((int)123, (int)bar.getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWork().getName());
        Assertions.assertFalse((boolean)prop.isEmpty(), (String)"Should NOT bind all properties");
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertTrue((boolean)prop.containsKey("?silver-Customer"));
        Assertions.assertTrue((boolean)prop.containsKey("?work.addresss"));
        Assertions.assertTrue((boolean)prop.containsKey("?work.addresss.zip"));
    }

    @Test
    public void testPropertiesOptionalKeyMandatory() {
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("?AGE", "33");
        prop.put("{{committer}}", "true");
        prop.put("gOLd-Customer", "true");
        prop.put("?silver-Customer", "true");
        prop.put("?work.ID", "123");
        prop.put("?WORk.naME", "{{companyName}}");
        prop.put("?work.addresss", "Some street");
        prop.put("?work.addresss.zip", "1234");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)7, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertEquals((int)123, (int)bar.getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWork().getName());
        Assertions.assertFalse((boolean)prop.isEmpty(), (String)"Should NOT bind all properties");
        Assertions.assertEquals((int)3, (int)prop.size());
        Assertions.assertTrue((boolean)prop.containsKey("?silver-Customer"));
        Assertions.assertTrue((boolean)prop.containsKey("?work.addresss"));
        Assertions.assertTrue((boolean)prop.containsKey("?work.addresss.zip"));
        prop.put("?unknown", "123");
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)bar, prop);
        prop.remove("?unknown");
        prop.put("unknown", "123");
        try {
            PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).withMandatory(true).bind((CamelContext)this.context, (Object)bar, prop);
            Assertions.fail((String)"Should fail");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"unknown", (Object)e.getPropertyName());
        }
    }

    @Test
    public void testPropertiesNoReflection() {
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.context);
        bi.setExtendedStatistics(true);
        bi.setLoggingLevel(LoggingLevel.WARN);
        Bar bar = new Bar();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("age", "33");
        prop.put("{{committer}}", "true");
        prop.put("gold-customer", "true");
        prop.put("work.id", "123");
        prop.put("work.name", "{{companyName}}");
        prop.put("products[foo]", "bar");
        this.myConfigurer.reset();
        PropertyBindingSupport.build().withReflection(false).withConfigurer((PropertyConfigurer)this.myConfigurer).withIgnoreCase(true).bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)9, (int)this.myConfigurer.getCounter());
        Assertions.assertEquals((int)33, (int)bar.getAge());
        Assertions.assertTrue((boolean)bar.isRider());
        Assertions.assertTrue((boolean)bar.isGoldCustomer());
        Assertions.assertEquals((int)0, (int)bar.getWork().getId());
        Assertions.assertNull((Object)bar.getWork().getName());
        Assertions.assertEquals((Object)"bar", (Object)bar.getProducts().get("foo"));
        Assertions.assertEquals((int)2, (int)prop.size());
        Assertions.assertEquals((Object)"123", prop.get("work.id"));
        Assertions.assertEquals((Object)"{{companyName}}", prop.get("work.name"));
        Assertions.assertEquals((long)0L, (long)bi.getInvokedCounter());
    }

    @Test
    public void testPropertiesDash() {
        PropertyBindingSupportTest.Foo foo = new PropertyBindingSupportTest.Foo();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.work.id", "123");
        prop.put("bar.work.name", "{{companyName}}");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)123, (int)foo.getBar().getWork().getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWork().getName());
        Assertions.assertTrue((boolean)prop.isEmpty(), (String)"Should bind all properties");
    }

    private static class MyConfigurer
    implements GeneratedPropertyConfigurer,
    PropertyConfigurerGetter {
        private int counter;

        private MyConfigurer() {
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof Bar) {
                Bar bar = (Bar)target;
                if ("age".equals(name)) {
                    bar.withAge(Integer.parseInt(value.toString()));
                    ++this.counter;
                    return true;
                }
                if ("rider".equals(name)) {
                    bar.withRider(Boolean.parseBoolean(value.toString()));
                    ++this.counter;
                    return true;
                }
                if ("work".equals(name)) {
                    bar.work((Company)value);
                    ++this.counter;
                    return true;
                }
                if ("products".equals(name)) {
                    bar.setProducts((Map)value);
                    ++this.counter;
                    return true;
                }
                if ("goldCustomer".equals(name) || "goldcustomer".equals(name)) {
                    bar.goldCustomer(Boolean.parseBoolean(value.toString()));
                    ++this.counter;
                    return true;
                }
            }
            return false;
        }

        public int getCounter() {
            return this.counter;
        }

        public void reset() {
            this.counter = 0;
        }

        public Class<?> getOptionType(String name, boolean ignoreCase) {
            if ("age".equals(name)) {
                return Integer.TYPE;
            }
            if ("rider".equals(name)) {
                return Boolean.TYPE;
            }
            if ("work".equals(name)) {
                return Company.class;
            }
            if ("products".equals(name)) {
                return Map.class;
            }
            if ("goldCustomer".equals(name) || "goldcustomer".equals(name)) {
                return Boolean.TYPE;
            }
            return null;
        }

        public Object getOptionValue(Object target, String name, boolean ignoreCase) {
            if (ignoreCase) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            if (target instanceof Bar) {
                Bar bar = (Bar)target;
                if ("age".equals(name)) {
                    ++this.counter;
                    return bar.getAge();
                }
                if ("rider".equals(name)) {
                    ++this.counter;
                    return bar.isRider();
                }
                if ("work".equals(name)) {
                    ++this.counter;
                    return bar.getWork();
                }
                if ("products".equals(name)) {
                    ++this.counter;
                    return bar.getProducts();
                }
                if ("goldCustomer".equals(name) || "goldcustomer".equals(name)) {
                    ++this.counter;
                    return bar.isGoldCustomer();
                }
            }
            return null;
        }
    }

    public static class Bar {
        private int age;
        private boolean rider;
        private Company work;
        private boolean goldCustomer;
        private Map<String, String> products;

        public int getAge() {
            return this.age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public Company getWork() {
            return this.work;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public Map<String, String> getProducts() {
            return this.products;
        }

        public void setProducts(Map<String, String> products) {
            this.products = products;
        }

        public Bar withAge(int age) {
            this.age = age;
            return this;
        }

        public Bar withRider(boolean rider) {
            this.rider = rider;
            return this;
        }

        public Bar work(Company work) {
            this.work = work;
            return this;
        }

        public Bar goldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
            return this;
        }
    }
}

