/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.Company;
import org.apache.camel.support.PropertyBindingSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportAutowireNestedTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work = new Company();
        work.setId(456);
        work.setName("Acme");
        context.getRegistry().bind("myWork", (Object)work);
        return context;
    }

    @Test
    public void testAutowireProperties() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "name", (Object)"James");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.age", (Object)"33");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.rider", (Object)"true");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, "bar.gold-customer", (Object)"true");
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertNull((Object)foo.getBar().getWork());
    }

    public static class Foo {
        private String name;
        private Bar bar = new Bar(this);

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }
    }

    public static class Bar {
        private Foo parent;
        private int age;
        private boolean rider;
        private Company work;
        private boolean goldCustomer;

        public Bar(Foo parent) {
            this.parent = parent;
        }

        public Foo getParent() {
            return this.parent;
        }

        public void setParent(Foo parent) {
            this.parent = parent;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public void setRider(boolean rider) {
            this.rider = rider;
        }

        public Company getWork() {
            return this.work;
        }

        public void setWork(Company work) {
            this.work = work;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public void setGoldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
        }
    }
}

