/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.support.Company;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyBindingSupportArrayTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Company work1 = new Company();
        work1.setId(123);
        work1.setName("Acme");
        context.getRegistry().bind("company1", (Object)work1);
        Company work2 = new Company();
        work2.setId(456);
        work2.setName("Acme 2");
        context.getRegistry().bind("company2", (Object)work2);
        Properties placeholders = new Properties();
        placeholders.put("companyName", "Acme");
        placeholders.put("committer", "rider");
        context.getPropertiesComponent().setInitialProperties(placeholders);
        return context;
    }

    @Test
    public void testPropertiesArray() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.works[0]", "#bean:company1");
        prop.put("bar.works[1]", "#bean:company2");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)2, (int)foo.getBar().getWorks().length);
        Assertions.assertEquals((int)123, (int)foo.getBar().getWorks()[0].getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWorks()[0].getName());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWorks()[1].getId());
        Assertions.assertEquals((Object)"Acme 2", (Object)foo.getBar().getWorks()[1].getName());
    }

    @Test
    public void testPropertiesArrayWithGaps() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.works[5]", "#bean:company1");
        prop.put("bar.works[9]", "#bean:company2");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)10, (int)foo.getBar().getWorks().length);
        Assertions.assertEquals((int)123, (int)foo.getBar().getWorks()[5].getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWorks()[5].getName());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWorks()[9].getId());
        Assertions.assertEquals((Object)"Acme 2", (Object)foo.getBar().getWorks()[9].getName());
    }

    @Test
    public void testPropertiesArrayNested() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.{{committer}}", "true");
        prop.put("bar.gold-customer", "true");
        prop.put("bar.works[0].id", "666");
        prop.put("bar.works[0]", "#bean:company1");
        prop.put("bar.works[1]", "#bean:company2");
        prop.put("bar.works[1].name", "I changed this");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
        Assertions.assertEquals((Object)"James", (Object)foo.getName());
        Assertions.assertEquals((int)33, (int)foo.getBar().getAge());
        Assertions.assertTrue((boolean)foo.getBar().isRider());
        Assertions.assertTrue((boolean)foo.getBar().isGoldCustomer());
        Assertions.assertEquals((int)2, (int)foo.getBar().getWorks().length);
        Assertions.assertEquals((int)666, (int)foo.getBar().getWorks()[0].getId());
        Assertions.assertEquals((Object)"Acme", (Object)foo.getBar().getWorks()[0].getName());
        Assertions.assertEquals((int)456, (int)foo.getBar().getWorks()[1].getId());
        Assertions.assertEquals((Object)"I changed this", (Object)foo.getBar().getWorks()[1].getName());
    }

    @Test
    public void testPropertiesArrayNestedSimple() {
        Foo foo = new Foo();
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, CollectionHelper.mapOf((Object)"bar.works[0].id", (Object)"666", (Object[])new Object[]{"bar.works[1].name", "I changed this"}));
        Assertions.assertEquals((int)666, (int)foo.bar.works[0].getId());
        Assertions.assertEquals((Object)"I changed this", (Object)foo.bar.works[1].getName());
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, CollectionHelper.mapOf((Object)"bar.works[0].id", (Object)"999", (Object[])new Object[]{"bar.works[1].name", "I changed this again"}));
        Assertions.assertEquals((int)999, (int)foo.bar.works[0].getId());
        Assertions.assertEquals((Object)"I changed this again", (Object)foo.bar.works[1].getName());
    }

    @Test
    public void testPropertiesArrayFirst() {
        Bar bar = new Bar();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("works[0]", "#bean:company1");
        prop.put("works[0].id", "666");
        prop.put("works[1]", "#bean:company2");
        prop.put("works[1].name", "I changed this");
        PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)bar, prop);
        Assertions.assertEquals((int)2, (int)bar.getWorks().length);
        Assertions.assertEquals((int)666, (int)bar.getWorks()[0].getId());
        Assertions.assertEquals((Object)"Acme", (Object)bar.getWorks()[0].getName());
        Assertions.assertEquals((int)456, (int)bar.getWorks()[1].getId());
        Assertions.assertEquals((Object)"I changed this", (Object)bar.getWorks()[1].getName());
    }

    @Test
    public void testPropertiesNotArray() {
        Foo foo = new Foo();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        prop.put("name", "James");
        prop.put("bar.age", "33");
        prop.put("bar.gold-customer[]", "true");
        try {
            PropertyBindingSupport.build().bind((CamelContext)this.context, (Object)foo, prop);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (PropertyBindingException e) {
            Assertions.assertEquals((Object)"gold-customer[]", (Object)e.getPropertyName());
            IllegalArgumentException iae = PropertyBindingSupportArrayTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertTrue((boolean)iae.getMessage().startsWith("Cannot set property: gold-customer[] as either a Map/List/array because target bean is not a Map, List or array type"));
        }
    }

    public static class Foo {
        String name;
        Bar bar = new Bar();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }
    }

    public static class Bar {
        int age;
        boolean rider;
        Company[] works;
        boolean goldCustomer;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isRider() {
            return this.rider;
        }

        public void setRider(boolean rider) {
            this.rider = rider;
        }

        public Company[] getWorks() {
            return this.works;
        }

        public void setWorks(Company[] works) {
            this.works = works;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }

        public void setGoldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
        }
    }
}

