/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.support.InputStreamIterator;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InputStreamIteratorTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInputStreamIterator() throws Exception {
        this.context.start();
        Iterator it = Stream.of("ABC", "DEF", "1234567890").iterator();
        InputStreamIterator is = new InputStreamIterator(this.context.getTypeConverter(), it);
        Assertions.assertEquals((int)3, (int)is.available());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)is, (OutputStream)bos);
        IOHelper.close((Closeable[])new Closeable[]{is, bos});
        Assertions.assertEquals((Object)"ABCDEF1234567890", (Object)bos.toString());
    }
}

