/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.GroupTokenIterator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.Scanner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GroupTokenIteratorTest
extends TestSupport {
    private CamelContext context;
    private Exchange exchange;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = new DefaultCamelContext();
        this.context.start();
        this.exchange = new DefaultExchange(this.context);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    @Test
    public void testGroupIterator() {
        String s = "ABC\nDEF\nGHI\nJKL\nMNO\nPQR\nSTU\nVW";
        Scanner scanner = new Scanner(s, "\n");
        GroupTokenIterator gi = new GroupTokenIterator(this.exchange, (Iterator)scanner, "\n", 3, false);
        Assertions.assertTrue((boolean)gi.hasNext());
        Assertions.assertEquals((Object)"ABC\nDEF\nGHI", (Object)gi.next());
        Assertions.assertEquals((Object)"JKL\nMNO\nPQR", (Object)gi.next());
        Assertions.assertEquals((Object)"STU\nVW", (Object)gi.next());
        Assertions.assertFalse((boolean)gi.hasNext());
        IOHelper.close((Closeable)gi);
    }

    @Test
    public void testGroupIteratorSkipFirst() {
        String s = "##comment\nABC\nDEF\nGHI\nJKL\nMNO\nPQR\nSTU\nVW";
        Scanner scanner = new Scanner(s, "\n");
        GroupTokenIterator gi = new GroupTokenIterator(this.exchange, (Iterator)scanner, "\n", 3, true);
        Assertions.assertTrue((boolean)gi.hasNext());
        Assertions.assertEquals((Object)"ABC\nDEF\nGHI", (Object)gi.next());
        Assertions.assertEquals((Object)"JKL\nMNO\nPQR", (Object)gi.next());
        Assertions.assertEquals((Object)"STU\nVW", (Object)gi.next());
        Assertions.assertFalse((boolean)gi.hasNext());
        IOHelper.close((Closeable)gi);
    }

    @Test
    public void testGroupIteratorWithDifferentEncodingFromDefault() {
        if (Charset.defaultCharset() == StandardCharsets.UTF_8) {
            return;
        }
        byte[] buf = "\u00a31\n\u00a32\n".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        Scanner scanner = new Scanner((InputStream)in, StandardCharsets.UTF_8.displayName(), "\n");
        this.exchange.setProperty("CamelCharsetName", (Object)StandardCharsets.UTF_8.displayName());
        GroupTokenIterator gi = new GroupTokenIterator(this.exchange, (Iterator)scanner, "\n", 1, false);
        Assertions.assertTrue((boolean)gi.hasNext());
        Assertions.assertEquals((Object)"\u00a31", (Object)gi.next());
        Assertions.assertEquals((Object)"\u00a32", (Object)gi.next());
        Assertions.assertFalse((boolean)gi.hasNext());
        IOHelper.close((Closeable)gi);
    }
}

