/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.TimeoutMap;
import org.apache.camel.support.DefaultTimeoutMap;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated(value="Depends on precise timing that may be hard to achieve if the system is under pressure")
@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class DefaultTimeoutMapTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTimeoutMapTest.class);
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    @Test
    public void testDefaultTimeoutMap() {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor);
        map.start();
        Assertions.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)map.size());
        map.stop();
    }

    @Test
    public void testDefaultTimeoutMapPurge() {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        Assertions.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        Assertions.assertEquals((int)1, (int)map.size());
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertEquals((int)0, (int)map.size()));
        map.stop();
    }

    @Test
    public void testDefaultTimeoutMapForcePurge() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        Assertions.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 10L);
        Assertions.assertEquals((int)1, (int)map.size());
        Thread.sleep(50L);
        map.purge();
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testDefaultTimeoutMapGetRemove() {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        Assertions.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)123, (int)((Integer)map.get((Object)"A")));
        Object old = map.remove((Object)"A");
        Assertions.assertEquals((Object)123, (Object)old);
        Assertions.assertNull((Object)map.get((Object)"A"));
        Assertions.assertEquals((int)0, (int)map.size());
        map.stop();
    }

    @Test
    public void testExecutor() {
        ScheduledExecutorService e = Executors.newScheduledThreadPool(2);
        DefaultTimeoutMap map = new DefaultTimeoutMap(e, 50L);
        map.start();
        Assertions.assertEquals((long)50L, (long)map.getPurgePollTime());
        map.put((Object)"A", (Object)123, 100L);
        Assertions.assertEquals((int)1, (int)map.size());
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertEquals((int)0, (int)map.size()));
        Assertions.assertSame((Object)e, (Object)map.getExecutor());
        map.stop();
    }

    @Test
    public void testExpiredInCorrectOrder() {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.addListener((type, key, value) -> {
            if (type == TimeoutMap.Listener.Type.Evict) {
                keys.add(key);
                values.add(value);
            }
        });
        map.start();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)1, 50L);
        map.put((Object)"B", (Object)2, 30L);
        map.put((Object)"C", (Object)3, 40L);
        map.put((Object)"D", (Object)4, 20L);
        map.put((Object)"E", (Object)5, 40L);
        map.put((Object)"F", (Object)6, 800L);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> {
            Assertions.assertFalse((boolean)keys.isEmpty());
            Assertions.assertEquals((Object)"D", keys.get(0));
        });
        Assertions.assertEquals((int)4, (int)((Integer)values.get(0)));
        Assertions.assertEquals((Object)"B", keys.get(1));
        Assertions.assertEquals((int)2, (int)((Integer)values.get(1)));
        Assertions.assertEquals((Object)"C", keys.get(2));
        Assertions.assertEquals((int)3, (int)((Integer)values.get(2)));
        Assertions.assertEquals((Object)"E", keys.get(3));
        Assertions.assertEquals((int)5, (int)((Integer)values.get(3)));
        Assertions.assertEquals((Object)"A", keys.get(4));
        Assertions.assertEquals((int)1, (int)((Integer)values.get(4)));
        Assertions.assertEquals((int)1, (int)map.size());
        map.stop();
    }

    @Test
    public void testDefaultTimeoutMapStopStart() {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        map.put((Object)"A", (Object)1, 500L);
        Assertions.assertEquals((int)1, (int)map.size());
        map.stop();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)1, 50L);
        Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> Assertions.assertEquals((int)1, (int)map.size()));
        map.start();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((int)0, (int)map.size()));
        map.stop();
    }
}

