/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.FooBar;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.Animal;
import org.apache.camel.support.Company;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.SimpleRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultRegistryTest {
    private final SimpleRegistry br = new SimpleRegistry();
    private final DefaultRegistry registry = new DefaultRegistry(new BeanRepository[]{this.br});
    private final Company myCompany = new Company();
    private final FooBar myFooBar = new FooBar();
    private final AtomicInteger counter = new AtomicInteger();

    @BeforeEach
    protected void setUp() {
        this.br.bind("myCompany", (Object)this.myCompany);
        this.registry.bind("myFooBar", (Object)this.myFooBar);
    }

    @Test
    public void testBindAsSupplierLookupByName() {
        this.counter.set(0);
        this.registry.bind("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        FooBar bar1 = (FooBar)this.registry.lookupByName("myBar");
        FooBar bar2 = (FooBar)this.registry.lookupByName("myBar");
        Assertions.assertSame((Object)bar1, (Object)bar2);
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar1.hello("me"));
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar2.hello("me"));
    }

    @Test
    public void testBindAsPrototypeSupplierLookupByName() {
        this.counter.set(0);
        this.registry.bindAsPrototype("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        FooBar bar1 = (FooBar)this.registry.lookupByName("myBar");
        FooBar bar2 = (FooBar)this.registry.lookupByName("myBar");
        Assertions.assertNotSame((Object)bar1, (Object)bar2);
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar1.hello("me"));
        Assertions.assertEquals((Object)"I am lazy 2 me", (Object)bar2.hello("me"));
    }

    @Test
    public void testBindAsPrototypeSupplierLookupByNameAndType() {
        this.counter.set(0);
        this.registry.bindAsPrototype("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        FooBar bar1 = (FooBar)this.registry.lookupByNameAndType("myBar", FooBar.class);
        FooBar bar2 = (FooBar)this.registry.lookupByNameAndType("myBar", FooBar.class);
        Assertions.assertNotSame((Object)bar1, (Object)bar2);
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar1.hello("me"));
        Assertions.assertEquals((Object)"I am lazy 2 me", (Object)bar2.hello("me"));
    }

    @Test
    public void testBindAsSupplierLookupByNameAndType() {
        this.counter.set(0);
        this.registry.bind("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        FooBar bar1 = (FooBar)this.registry.lookupByNameAndType("myBar", FooBar.class);
        FooBar bar2 = (FooBar)this.registry.lookupByNameAndType("myBar", FooBar.class);
        Assertions.assertSame((Object)bar1, (Object)bar2);
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar1.hello("me"));
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)bar2.hello("me"));
    }

    @Test
    public void testBindAsSupplierFindByType() {
        this.counter.set(0);
        this.registry.bind("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        Set set = this.registry.findByType(FooBar.class);
        Assertions.assertEquals((int)2, (int)set.size());
        Iterator it = set.iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
        set = this.registry.findByType(FooBar.class);
        Assertions.assertEquals((int)2, (int)set.size());
        it = set.iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
    }

    @Test
    public void testBindAsPrototypeSupplierFindByType() {
        this.counter.set(0);
        this.registry.bindAsPrototype("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        Set set = this.registry.findByType(FooBar.class);
        Assertions.assertEquals((int)2, (int)set.size());
        Iterator it = set.iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
        set = this.registry.findByType(FooBar.class);
        Assertions.assertEquals((int)2, (int)set.size());
        it = set.iterator();
        Assertions.assertEquals((Object)"I am lazy 2 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
    }

    @Test
    public void testBindAsPrototypeSupplierFindByTypeWithName() {
        this.counter.set(0);
        this.registry.bindAsPrototype("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        Map map = this.registry.findByTypeWithName(FooBar.class);
        Assertions.assertEquals((int)2, (int)map.size());
        Iterator it = map.values().iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
        map = this.registry.findByTypeWithName(FooBar.class);
        Assertions.assertEquals((int)2, (int)map.size());
        it = map.values().iterator();
        Assertions.assertEquals((Object)"I am lazy 2 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
    }

    @Test
    public void testBindAsSupplierFindByTypeWithName() {
        this.counter.set(0);
        this.registry.bind("myBar", FooBar.class, () -> {
            FooBar bar = new FooBar();
            bar.setGreeting("I am lazy " + this.counter.incrementAndGet());
            return bar;
        });
        Map map = this.registry.findByTypeWithName(FooBar.class);
        Assertions.assertEquals((int)2, (int)map.size());
        Iterator it = map.values().iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
        map = this.registry.findByTypeWithName(FooBar.class);
        Assertions.assertEquals((int)2, (int)map.size());
        it = map.values().iterator();
        Assertions.assertEquals((Object)"I am lazy 1 me", (Object)((FooBar)it.next()).hello("me"));
        Assertions.assertSame((Object)this.myFooBar, it.next());
    }

    @Test
    public void testLookupByName() {
        Assertions.assertNull((Object)this.registry.lookupByName("foo"));
        Assertions.assertSame((Object)this.myCompany, (Object)this.registry.lookupByName("myCompany"));
        Assertions.assertSame((Object)this.myFooBar, (Object)this.registry.lookupByName("myFooBar"));
    }

    @Test
    public void testLookupByNameAndType() {
        Assertions.assertNull((Object)this.registry.lookupByNameAndType("foo", Object.class));
        Assertions.assertSame((Object)this.myCompany, (Object)this.registry.lookupByNameAndType("myCompany", Company.class));
        Assertions.assertSame((Object)this.myFooBar, (Object)this.registry.lookupByNameAndType("myFooBar", FooBar.class));
        Assertions.assertSame((Object)this.myCompany, (Object)this.registry.lookupByNameAndType("myCompany", Object.class));
        Assertions.assertSame((Object)this.myFooBar, (Object)this.registry.lookupByNameAndType("myFooBar", Object.class));
        Assertions.assertNull((Object)this.registry.lookupByNameAndType("myCompany", FooBar.class));
        Assertions.assertNull((Object)this.registry.lookupByNameAndType("myFooBar", Company.class));
    }

    @Test
    public void testFindByType() {
        Assertions.assertEquals((int)0, (int)this.registry.findByType(DefaultRegistry.class).size());
        Assertions.assertEquals((int)1, (int)this.registry.findByType(Company.class).size());
        Assertions.assertEquals((Object)this.myCompany, this.registry.findByType(Company.class).iterator().next());
        Assertions.assertEquals((int)1, (int)this.registry.findByType(FooBar.class).size());
        Assertions.assertEquals((Object)this.myFooBar, this.registry.findByType(FooBar.class).iterator().next());
        Assertions.assertEquals((int)2, (int)this.registry.findByType(Object.class).size());
        Iterator it = this.registry.findByType(Object.class).iterator();
        Assertions.assertSame((Object)this.myCompany, it.next());
        Assertions.assertSame((Object)this.myFooBar, it.next());
    }

    @Test
    public void testFindByTypeWithName() {
        Assertions.assertEquals((int)0, (int)this.registry.findByTypeWithName(DefaultRegistry.class).size());
        Assertions.assertEquals((int)1, (int)this.registry.findByTypeWithName(Company.class).size());
        Assertions.assertEquals((Object)this.myCompany, this.registry.findByTypeWithName(Company.class).values().iterator().next());
        Assertions.assertEquals((int)1, (int)this.registry.findByTypeWithName(FooBar.class).size());
        Assertions.assertEquals((Object)this.myFooBar, this.registry.findByTypeWithName(FooBar.class).values().iterator().next());
        Assertions.assertEquals((int)2, (int)this.registry.findByTypeWithName(Object.class).size());
        Iterator it = this.registry.findByTypeWithName(Object.class).keySet().iterator();
        Assertions.assertEquals((Object)"myCompany", it.next());
        Assertions.assertEquals((Object)"myFooBar", it.next());
    }

    @Test
    public void testBindCamelContextAwareInject() {
        DefaultCamelContext context = new DefaultCamelContext();
        this.registry.setCamelContext((CamelContext)context);
        MyBean my = new MyBean("Tiger");
        this.registry.bind("tiger", (Object)my);
        MyBean lookup = (MyBean)this.registry.lookupByName("tiger");
        Assertions.assertSame((Object)my, (Object)lookup);
        Assertions.assertNotNull((Object)lookup.getCamelContext());
        Assertions.assertSame((Object)context, (Object)lookup.getCamelContext());
    }

    @Test
    public void testFindSingleByTypeWithMultipleRepositories() {
        SimpleRegistry sr = new SimpleRegistry();
        Animal myAnimal = new Animal();
        sr.bind("myAnimal", (Object)myAnimal);
        this.registry.addBeanRepository((BeanRepository)sr);
        Assertions.assertNotNull((Object)this.registry.findSingleByType(Animal.class));
        Assertions.assertNotNull((Object)this.registry.findSingleByType(Company.class));
    }

    private static class MyBean
    implements CamelContextAware {
        private CamelContext camelContext;
        private final String name;

        public MyBean(String name) {
            this.name = name;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public String getName() {
            return this.name;
        }
    }
}

