/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.URISupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultEndpointTest
extends ContextTestSupport {
    @Test
    public void testSanitizeUri() {
        Assertions.assertNull((Object)URISupport.sanitizeUri(null));
        Assertions.assertEquals((Object)"", (Object)URISupport.sanitizeUri((String)""));
        this.assertSanitizedUriUnchanged("http://camel.apache.org");
        this.assertSanitizedUriUnchanged("irc://irc.codehaus.org/camel");
        this.assertSanitizedUriUnchanged("direct:foo?bar=123&cheese=yes");
        this.assertSanitizedUriUnchanged("https://issues.apache.org/activemq/secure/AddComment!default.jspa?id=33239");
        Assertions.assertEquals((Object)"ftp://host.mysite.com/records?passiveMode=true&user=xxxxxx&password=xxxxxx", (Object)URISupport.sanitizeUri((String)"ftp://host.mysite.com/records?passiveMode=true&user=someuser&password=superSecret"));
        Assertions.assertEquals((Object)"sftp://host.mysite.com/records?user=xxxxxx&privateKeyFile=xxxxxx&privateKeyFilePassphrase=xxxxxx&knownHostsFile=hosts.list", (Object)URISupport.sanitizeUri((String)"sftp://host.mysite.com/records?user=someuser&privateKeyFile=key.file&privateKeyFilePassphrase=superSecret&knownHostsFile=hosts.list"));
    }

    @Test
    public void testToString() {
        String epstr = "myep:///test";
        MyEndpoint ep = new MyEndpoint();
        ep.setEndpointUri("myep:///test");
        Assertions.assertTrue((boolean)ep.toString().contains("myep:///test"));
    }

    private void assertSanitizedUriUnchanged(String uri) {
        Assertions.assertEquals((Object)uri, (Object)URISupport.sanitizeUri((String)uri));
    }

    private static class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint() {
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }
    }
}

