/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentTest
extends ContextTestSupport {
    @Test
    public void testResolveRawDefault() {
        this.context.addComponent("dummy", (Component)new MyComponent());
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("dummy:test?test=RAW(value)", MyEndpoint.class);
        Assertions.assertEquals((Object)"value", (Object)endpoint.getParameters().get("test"));
    }

    @Test
    public void testResolveRawTrue() {
        this.context.addComponent("dummy", (Component)new MyComponent(true));
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("dummy:test?test=RAW(value)", MyEndpoint.class);
        Assertions.assertEquals((Object)"value", (Object)endpoint.getParameters().get("test"));
    }

    @Test
    public void testResolveRawFalse() {
        this.context.addComponent("dummy", (Component)new MyComponent(false));
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("dummy:test?test=RAW(value)", MyEndpoint.class);
        Assertions.assertEquals((Object)"RAW(value)", (Object)endpoint.getParameters().get("test"));
    }

    private static class MyComponent
    extends DefaultComponent {
        private final Boolean raw;

        public MyComponent() {
            this(null);
        }

        public MyComponent(Boolean raw) {
            this.raw = raw;
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            MyEndpoint answer = new MyEndpoint(parameters);
            parameters.clear();
            return answer;
        }

        protected boolean resolveRawParameterValues() {
            return this.raw != null ? this.raw.booleanValue() : super.resolveRawParameterValues();
        }
    }

    private static class MyEndpoint
    extends DefaultEndpoint {
        private final Map<String, Object> parameters;

        public MyEndpoint(Map<String, Object> parameters) {
            this.parameters = new HashMap<String, Object>(parameters);
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

