/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextEndpointCacheLimitTest
extends ContextTestSupport {
    @Test
    public void testCacheEndpoints() throws Exception {
        for (int i = 0; i < 100; ++i) {
            String uri = "my:endpoint?id=" + i;
            DefaultEndpoint e = new DefaultEndpoint(){

                public Producer createProducer() {
                    return null;
                }

                public Consumer createConsumer(Processor processor) {
                    return null;
                }

                public boolean isSingleton() {
                    return true;
                }
            };
            e.setCamelContext((CamelContext)this.context);
            e.setEndpointUri(uri);
            this.context.addEndpoint(uri, (Endpoint)e);
        }
        this.context.getEndpointRegistry().cleanUp();
        Collection col = this.context.getEndpoints();
        Assertions.assertTrue((col.size() <= 75 ? 1 : 0) != 0, (String)("Size should be at most 75 was " + col.size()));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getGlobalOptions().put("CamelMaximumEndpointCacheSize", "75");
        return context;
    }
}

