/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.support.CustomizersSupport;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CustomizersTest {
    public static Stream<Arguments> disableLanguageCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.language.enabled", "true", "camel.customizer.language.tokenize.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.language.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[0])}));
    }

    public static Stream<Arguments> enableLanguageCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.language.enabled", "false", "camel.customizer.language.tokenize.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.language.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[0])}));
    }

    public static Stream<Arguments> disableDataFormatCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.dataformat.enabled", "true", "camel.customizer.dataformat.my-df.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.dataformat.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[0])}));
    }

    public static Stream<Arguments> enableDataFormatCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.dataformat.enabled", "false", "camel.customizer.dataformat.my-df.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.dataformat.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[0])}));
    }

    public static Stream<Arguments> disableComponentCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.component.enabled", "true", "camel.customizer.component.log.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[]{"camel.customizer.component.enabled", "false"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[0])}));
    }

    public static Stream<Arguments> enableComponentCustomizationProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.component.enabled", "false", "camel.customizer.component.log.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"false", (String[])new String[]{"camel.customizer.component.enabled", "true"})}), Arguments.of((Object[])new Object[]{CollectionHelper.propertiesOf((String)"camel.customizer.enabled", (String)"true", (String[])new String[0])}));
    }

    @Test
    public void testComponentCustomization() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("log-customizer", (Object)ComponentCustomizer.forType(LogComponent.class, target -> target.setExchangeFormatter((ExchangeFormatter)new MyExchangeFormatter())));
        Assertions.assertInstanceOf(MyExchangeFormatter.class, (Object)((LogComponent)context.getComponent("log", LogComponent.class)).getExchangeFormatter());
    }

    @Test
    public void testComponentCustomizationWithFilter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)ComponentCustomizer.Policy.none());
        context.getCamelContextExtension().getRegistry().bind("log-customizer", (Object)ComponentCustomizer.forType(LogComponent.class, target -> target.setExchangeFormatter((ExchangeFormatter)new MyExchangeFormatter())));
        Assertions.assertFalse((boolean)(((LogComponent)context.getComponent("log", LogComponent.class)).getExchangeFormatter() instanceof MyExchangeFormatter));
    }

    @Test
    public void testComponentCustomizationWithFluentBuilder() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("log-customizer", (Object)ComponentCustomizer.forType(LogComponent.class, target -> target.setExchangeFormatter((ExchangeFormatter)new MyExchangeFormatter())));
        Assertions.assertInstanceOf(MyExchangeFormatter.class, (Object)((LogComponent)context.getComponent("log", LogComponent.class)).getExchangeFormatter());
    }

    @ParameterizedTest
    @MethodSource(value={"disableComponentCustomizationProperties"})
    public void testComponentCustomizationDisabledByProperty(Properties properties) {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getPropertiesComponent().setInitialProperties(properties);
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)new CustomizersSupport.ComponentCustomizationEnabledPolicy());
        context.getCamelContextExtension().getRegistry().bind("log-customizer", (Object)ComponentCustomizer.forType(LogComponent.class, target -> target.setExchangeFormatter((ExchangeFormatter)new MyExchangeFormatter())));
        Assertions.assertFalse((boolean)(((LogComponent)context.getComponent("log", LogComponent.class)).getExchangeFormatter() instanceof MyExchangeFormatter));
    }

    @ParameterizedTest
    @MethodSource(value={"enableComponentCustomizationProperties"})
    public void testComponentCustomizationEnabledByProperty(Properties properties) {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getPropertiesComponent().setInitialProperties(properties);
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)new CustomizersSupport.ComponentCustomizationEnabledPolicy());
        context.getCamelContextExtension().getRegistry().bind("log-customizer", (Object)ComponentCustomizer.forType(LogComponent.class, target -> target.setExchangeFormatter((ExchangeFormatter)new MyExchangeFormatter())));
        Assertions.assertInstanceOf(MyExchangeFormatter.class, (Object)((LogComponent)context.getComponent("log", LogComponent.class)).getExchangeFormatter());
    }

    @Test
    public void testDataFormatCustomization() {
        AtomicInteger counter = new AtomicInteger();
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("my-df", MyDataFormat::new);
        context.getCamelContextExtension().getRegistry().bind("my-df-customizer", (Object)DataFormatCustomizer.forType(MyDataFormat.class, target -> target.setId(counter.incrementAndGet())));
        DataFormat df1 = context.createDataFormat("my-df");
        DataFormat df2 = context.createDataFormat("my-df");
        Assertions.assertNotEquals((Object)df1, (Object)df2);
        Assertions.assertInstanceOf(MyDataFormat.class, (Object)df1);
        Assertions.assertEquals((int)1, (int)((MyDataFormat)df1).getId());
        Assertions.assertInstanceOf(MyDataFormat.class, (Object)df2);
        Assertions.assertEquals((int)2, (int)((MyDataFormat)df2).getId());
    }

    @Test
    public void testDataFormatCustomizationWithFilter() {
        AtomicInteger counter = new AtomicInteger();
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)DataFormatCustomizer.Policy.none());
        context.getCamelContextExtension().getRegistry().bind("my-df", MyDataFormat::new);
        context.getCamelContextExtension().getRegistry().bind("my-df-customizer", (Object)DataFormatCustomizer.forType(MyDataFormat.class, target -> target.setId(counter.incrementAndGet())));
        DataFormat df1 = context.createDataFormat("my-df");
        DataFormat df2 = context.createDataFormat("my-df");
        Assertions.assertNotEquals((Object)df1, (Object)df2);
        Assertions.assertInstanceOf(MyDataFormat.class, (Object)df1);
        Assertions.assertEquals((int)0, (int)((MyDataFormat)df1).getId());
        Assertions.assertInstanceOf(MyDataFormat.class, (Object)df2);
        Assertions.assertEquals((int)0, (int)((MyDataFormat)df2).getId());
    }

    @ParameterizedTest
    @MethodSource(value={"disableDataFormatCustomizationProperties"})
    public void testDataFormatCustomizationDisabledByProperty(Properties properties) {
        AtomicInteger counter = new AtomicInteger();
        DefaultCamelContext context = new DefaultCamelContext();
        context.getPropertiesComponent().setInitialProperties(properties);
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)new CustomizersSupport.DataFormatCustomizationEnabledPolicy());
        context.getCamelContextExtension().getRegistry().bind("my-df", MyDataFormat::new);
        context.getCamelContextExtension().getRegistry().bind("my-df-customizer", (Object)DataFormatCustomizer.forType(MyDataFormat.class, target -> target.setId(counter.incrementAndGet())));
        DataFormat df1 = context.resolveDataFormat("my-df");
        Assertions.assertEquals((int)0, (int)((MyDataFormat)df1).getId());
    }

    @ParameterizedTest
    @MethodSource(value={"enableDataFormatCustomizationProperties"})
    public void testDataFormatCustomizationEnabledByProperty(Properties properties) {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getPropertiesComponent().setInitialProperties(properties);
        context.getCamelContextExtension().getRegistry().bind("customizer-filter", (Object)new CustomizersSupport.DataFormatCustomizationEnabledPolicy());
        context.getCamelContextExtension().getRegistry().bind("my-df", MyDataFormat::new);
        context.getCamelContextExtension().getRegistry().bind("my-df-customizer", (Object)DataFormatCustomizer.forType(MyDataFormat.class, target -> target.setId(1)));
        DataFormat df1 = context.resolveDataFormat("my-df");
        Assertions.assertEquals((int)1, (int)((MyDataFormat)df1).getId());
    }

    public static class MyExchangeFormatter
    extends DefaultExchangeFormatter {
    }

    public static class MyDataFormat
    implements DataFormat {
        private int id;

        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            return null;
        }

        public void start() {
        }

        public void stop() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

