/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.clock.Clock;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.MonotonicClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractExchangeTest {
    @Test
    void shouldPreserveDataTypeOnCopy() {
        CustomAbstractExchange e1 = new CustomAbstractExchange((CamelContext)new DefaultCamelContext());
        Object body1 = new Object();
        DataType type1 = new DataType("foo1");
        DefaultMessage in = new DefaultMessage((Exchange)null);
        in.setBody(body1, type1);
        e1.setIn((Message)in);
        Object body2 = new Object();
        DataType type2 = new DataType("foo2");
        DefaultMessage out = new DefaultMessage((Exchange)null);
        out.setBody(body2, type2);
        e1.setOut((Message)out);
        Exchange e2 = e1.copy();
        Assertions.assertSame((Object)body1, (Object)e2.getIn().getBody());
        Assertions.assertInstanceOf(DataTypeAware.class, (Object)e2.getIn());
        Assertions.assertSame((Object)type1, (Object)((DataTypeAware)e2.getIn()).getDataType());
        Assertions.assertSame((Object)body2, (Object)e2.getMessage().getBody());
        Assertions.assertInstanceOf(DataTypeAware.class, (Object)e2.getMessage());
        Assertions.assertSame((Object)type2, (Object)((DataTypeAware)e2.getMessage()).getDataType());
    }

    static class CustomAbstractExchange
    extends AbstractExchange {
        private final Clock clock = new MonotonicClock();

        CustomAbstractExchange(CustomAbstractExchange abstractExchange) {
            super((AbstractExchange)abstractExchange);
        }

        public CustomAbstractExchange(CamelContext context) {
            super(context);
        }

        AbstractExchange newCopy() {
            return new CustomAbstractExchange(this);
        }

        public Clock getClock() {
            return this.clock;
        }
    }
}

