/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validator;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorXmlSchemaTest
extends ContextTestSupport {
    @Test
    public void shouldPass() throws Exception {
        String body = "<user><name>Jan</name></user>";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"<user><name>Jan</name></user>"});
        this.template.sendBody("direct:in", (Object)"<user><name>Jan</name></user>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void shouldThrowException() throws Exception {
        String body = "<fail/>";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:in", (Object)"<fail/>");
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            ValidatorXmlSchemaTest.assertIsInstanceOf(ValidationException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.validator().type("xml").withUri("validator:org/apache/camel/impl/validate.xsd");
                this.from("direct:in").inputTypeWithValidate("xml").to("mock:result");
            }
        };
    }
}

